/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractReferenceProcessor<A extends Annotation, I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<A, I> {
    protected JavaContractProcessor contractProcessor;
    protected IntrospectionHelper helper;
    protected PolicyAnnotationProcessor policyProcessor;

    public AbstractReferenceProcessor(Class<A> annotation, JavaContractProcessor contractProcessor, IntrospectionHelper helper) {
        super(annotation);
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    protected ReferenceDefinition createDefinition(String name, boolean required, Type type, Class<?> implClass, Annotation[] annotations, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        Class baseType = this.helper.getBaseType(type, typeMapping);
        JavaServiceContract contract = this.contractProcessor.introspect(baseType, implClass, context);
        ReferenceDefinition definition = new ReferenceDefinition(name, (ServiceContract)contract);
        this.helper.processMultiplicity(definition, required, type, typeMapping);
        if (this.policyProcessor != null) {
            for (Annotation annotation : annotations) {
                this.policyProcessor.process(annotation, (PolicyAware)definition, context);
            }
        }
        return definition;
    }
}

