/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.osoa.sca.ComponentContext;
import org.osoa.sca.RequestContext;
import org.osoa.sca.annotations.Context;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Context, I> {
    private final IntrospectionHelper helper;

    public ContextProcessor(@Reference IntrospectionHelper helper) {
        super(Context.class);
        this.helper = helper;
    }

    public void visitField(Context annotation, Field field, Class<?> implClass, I implementation, IntrospectionContext context) {
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        Injectable injectable = null;
        if (type instanceof Class) {
            injectable = this.getContext((Class)type);
        }
        if (injectable != null) {
            ((InjectingComponentType)implementation.getComponentType()).addInjectionSite((InjectionSite)site, injectable);
        }
    }

    public void visitMethod(Context annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        Injectable attribute = null;
        if (type instanceof Class) {
            attribute = this.getContext((Class)type);
        }
        if (attribute != null) {
            ((InjectingComponentType)implementation.getComponentType()).addInjectionSite((InjectionSite)site, attribute);
        }
    }

    Injectable getContext(Class<?> type) {
        if (RequestContext.class.isAssignableFrom(type)) {
            return Injectable.REQUEST_CONTEXT;
        }
        if (ComponentContext.class.isAssignableFrom(type)) {
            return Injectable.COMPONENT_CONTEXT;
        }
        return null;
    }
}

