/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.InvalidAccessor;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.Signature;
import org.osoa.sca.annotations.Init;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InitProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Init, I> {
    public InitProcessor() {
        super(Init.class);
    }

    public void visitMethod(Init annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        if (!this.validateAccessor(method, context)) {
            return;
        }
        ((InjectingComponentType)implementation.getComponentType()).setInitMethod(new Signature(method));
    }

    private boolean validateAccessor(Method method, IntrospectionContext context) {
        if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) {
            Class<?> clazz = method.getDeclaringClass();
            InvalidAccessor warning = new InvalidAccessor("Ignoring " + method + " annotated with @Init. Initializers must be public or protected.", clazz);
            context.addWarning((ValidationFailure)warning);
            return false;
        }
        return true;
    }
}

