/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Method;
import java.util.HashSet;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.security.Role;
import org.fabric3.introspection.java.annotation.InvalidAnnotation;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.ManagementInfo;
import org.fabric3.spi.model.type.java.ManagementOperationInfo;
import org.fabric3.spi.model.type.java.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementOperationProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<ManagementOperation, I> {
    public ManagementOperationProcessor() {
        super(ManagementOperation.class);
    }

    public void visitMethod(ManagementOperation annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        ManagementInfo info = componentType.getManagementInfo();
        if (info == null) {
            Class<?> clazz = method.getDeclaringClass();
            context.addError((ValidationFailure)new InvalidAnnotation("Implementation is missing @" + Management.class.getSimpleName() + ": " + clazz));
            return;
        }
        String description = annotation.description();
        if (description.trim().length() == 0) {
            description = null;
        }
        Signature signature = new Signature(method);
        HashSet<Role> roles = new HashSet<Role>();
        for (String roleName : annotation.rolesAllowed()) {
            roles.add(new Role(roleName));
        }
        ManagementOperationInfo operationInfo = new ManagementOperationInfo(signature, description, roles);
        info.addOperation(operationInfo);
    }
}

