/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.util.HashSet;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.host.security.Role;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.ManagementInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Management, I> {
    public ManagementProcessor() {
        super(Management.class);
    }

    public void visitType(Management annotation, Class<?> type, I implementation, IntrospectionContext context) {
        String description;
        String group;
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        componentType.setManaged(true);
        String name = annotation.name();
        if (name.trim().length() == 0) {
            name = type.getSimpleName();
        }
        if ((group = annotation.group()).trim().length() == 0) {
            group = null;
        }
        if ((description = annotation.description()).trim().length() == 0) {
            description = null;
        }
        HashSet<Role> readRoles = new HashSet<Role>();
        for (String roleName : annotation.readRoles()) {
            readRoles.add(new Role(roleName));
        }
        HashSet<Role> writeRoles = new HashSet<Role>();
        for (String roleName : annotation.writeRoles()) {
            writeRoles.add(new Role(roleName));
        }
        ManagementInfo info = new ManagementInfo(name, group, description, type.getName(), readRoles, writeRoles);
        ManagementInfo overriden = componentType.getManagementInfo();
        if (overriden != null) {
            info.getOperations().addAll(overriden.getOperations());
        }
        componentType.setManagementInfo(info);
    }
}

