/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import javax.xml.namespace.QName;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.EagerInitNotSupported;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Scope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OASISEagerInitProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<EagerInit, I> {
    public static final QName IMPLEMENTATION_SYSTEM = new QName("urn:fabric3.org:implementation", "implementation.system");

    public OASISEagerInitProcessor() {
        super(EagerInit.class);
    }

    public void visitType(EagerInit annotation, Class<?> type, I implementation, IntrospectionContext context) {
        if (!this.validateScope(type, implementation, context)) {
            return;
        }
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        componentType.setInitLevel(50);
    }

    private boolean validateScope(Class<?> type, I implementation, IntrospectionContext context) {
        if (IMPLEMENTATION_SYSTEM.equals(implementation.getType())) {
            return true;
        }
        Scope scope = type.getAnnotation(Scope.class);
        if (scope == null || !org.fabric3.model.type.component.Scope.COMPOSITE.getScope().equals(scope.value()) && !org.fabric3.model.type.component.Scope.DOMAIN.getScope().equals(scope.value())) {
            EagerInitNotSupported warning = new EagerInitNotSupported(type);
            context.addWarning((ValidationFailure)warning);
            return false;
        }
        return true;
    }
}

