/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.InvalidAccessor;
import org.fabric3.introspection.java.annotation.InvalidMethod;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.MultiplicityType;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.oasisopen.sca.annotation.Property;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OASISPropertyProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Property, I> {
    private final IntrospectionHelper helper;

    public OASISPropertyProcessor(@Reference IntrospectionHelper helper) {
        super(Property.class);
        this.helper = helper;
    }

    public void visitField(Property annotation, Field field, Class<?> implClass, I implementation, IntrospectionContext context) {
        this.validate(annotation, field, context);
        String name = this.helper.getSiteName(field, annotation.name());
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        boolean required = annotation.required();
        org.fabric3.model.type.component.Property property = this.createDefinition(name, required, type, typeMapping);
        ((InjectingComponentType)implementation.getComponentType()).add(property, (InjectionSite)site);
    }

    public void visitMethod(Property annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        boolean result = this.validate(annotation, method, context);
        if (!result) {
            return;
        }
        String name = this.helper.getSiteName(method, annotation.name());
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        boolean required = annotation.required();
        org.fabric3.model.type.component.Property property = this.createDefinition(name, required, type, typeMapping);
        ((InjectingComponentType)implementation.getComponentType()).add(property, (InjectionSite)site);
    }

    private void validate(Property annotation, Field field, IntrospectionContext context) {
        if (!Modifier.isProtected(field.getModifiers()) && !Modifier.isPublic(field.getModifiers())) {
            Class<?> clazz = field.getDeclaringClass();
            if (annotation.required()) {
                InvalidAccessor error = new InvalidAccessor("Invalid required property. The field " + field.getName() + " on " + clazz.getName() + " is annotated with @Property but properties must be public or protected.", clazz);
                context.addError((ValidationFailure)error);
            } else {
                InvalidAccessor warning = new InvalidAccessor("Ignoring the field " + field.getName() + " annotated with @Property on " + clazz.getName() + ". Properties must be public or protected.", clazz);
                context.addWarning((ValidationFailure)warning);
            }
        }
    }

    private boolean validate(Property annotation, Method method, IntrospectionContext context) {
        if (method.getParameterTypes().length != 1) {
            InvalidMethod error = new InvalidMethod("Setter methods for properties must have a single parameter: " + method);
            context.addError((ValidationFailure)error);
            return false;
        }
        if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) {
            Class<?> clazz = method.getDeclaringClass();
            if (annotation.required()) {
                InvalidAccessor error = new InvalidAccessor("Invalid required property. The method " + method + " is annotated with @Property and must be public or protected.", clazz);
                context.addError((ValidationFailure)error);
                return false;
            }
            InvalidAccessor warning = new InvalidAccessor("Ignoring " + method + " annotated with @Property. Property " + "must be public or protected.", clazz);
            context.addWarning((ValidationFailure)warning);
            return false;
        }
        return true;
    }

    public void visitConstructorParameter(Property annotation, Constructor<?> constructor, int index, Class<?> implClass, I implementation, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.name());
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        TypeMapping typeMapping = context.getTypeMapping(implClass);
        boolean required = annotation.required();
        org.fabric3.model.type.component.Property property = this.createDefinition(name, required, type, typeMapping);
        ((InjectingComponentType)implementation.getComponentType()).add(property, (InjectionSite)site);
    }

    private org.fabric3.model.type.component.Property createDefinition(String name, boolean required, Type type, TypeMapping typeMapping) {
        org.fabric3.model.type.component.Property property = new org.fabric3.model.type.component.Property(name);
        property.setRequired(required);
        MultiplicityType multiplicityType = this.helper.introspectMultiplicity(type, typeMapping);
        property.setMany(MultiplicityType.COLLECTION == multiplicityType || MultiplicityType.DICTIONARY == multiplicityType);
        return property;
    }
}

