/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.annotation.AbstractReferenceProcessor;
import org.fabric3.introspection.java.annotation.InvalidAccessor;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.ConstructorInjectionSite;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractReferenceProcessor<Reference, I> {
    public ReferenceProcessor(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        super(Reference.class, contractProcessor, helper);
    }

    public void visitField(Reference annotation, Field field, Class<?> implClass, I implementation, IntrospectionContext context) {
        this.validate(annotation, field, context);
        String name = this.helper.getSiteName(field, annotation.name());
        Type type = field.getGenericType();
        FieldInjectionSite site = new FieldInjectionSite(field);
        Annotation[] annotations = field.getAnnotations();
        boolean required = annotation.required();
        ReferenceDefinition definition = this.createDefinition(name, required, type, implClass, annotations, context);
        ((InjectingComponentType)implementation.getComponentType()).add(definition, (InjectionSite)site);
    }

    public void visitMethod(Reference annotation, Method method, Class<?> implClass, I implementation, IntrospectionContext context) {
        this.validate(annotation, method, context);
        String name = this.helper.getSiteName(method, annotation.name());
        Type type = this.helper.getGenericType(method);
        MethodInjectionSite site = new MethodInjectionSite(method, 0);
        Annotation[] annotations = method.getAnnotations();
        boolean required = annotation.required();
        ReferenceDefinition definition = this.createDefinition(name, required, type, implClass, annotations, context);
        ((InjectingComponentType)implementation.getComponentType()).add(definition, (InjectionSite)site);
    }

    private void validate(Reference annotation, Field field, IntrospectionContext context) {
        if (!Modifier.isProtected(field.getModifiers()) && !Modifier.isPublic(field.getModifiers())) {
            Class<?> clazz = field.getDeclaringClass();
            if (annotation.required()) {
                InvalidAccessor error = new InvalidAccessor("Invalid required reference. The field " + field.getName() + " on " + clazz.getName() + " is annotated with @Reference and must be public or protected.", clazz);
                context.addError((ValidationFailure)error);
            } else {
                InvalidAccessor warning = new InvalidAccessor("Ignoring the field " + field.getName() + " annotated with @Reference on " + clazz.getName() + ". References must be public or protected.", clazz);
                context.addWarning((ValidationFailure)warning);
            }
        }
    }

    private void validate(Reference annotation, Method method, IntrospectionContext context) {
        if (!Modifier.isProtected(method.getModifiers()) && !Modifier.isPublic(method.getModifiers())) {
            Class<?> clazz = method.getDeclaringClass();
            if (annotation.required()) {
                InvalidAccessor error = new InvalidAccessor("Invalid required reference. The method " + method + " on " + clazz.getName() + " is annotated with @Reference and must be public or protected.", clazz);
                context.addError((ValidationFailure)error);
            } else {
                InvalidAccessor warning = new InvalidAccessor("Ignoring " + method + " annotated with @Reference. References " + "must be public or protected.", clazz);
                context.addWarning((ValidationFailure)warning);
            }
        }
    }

    public void visitConstructorParameter(Reference annotation, Constructor<?> constructor, int index, Class<?> implClass, I implementation, IntrospectionContext context) {
        String name = this.helper.getSiteName(constructor, index, annotation.name());
        Type type = this.helper.getGenericType(constructor, index);
        ConstructorInjectionSite site = new ConstructorInjectionSite(constructor, index);
        Annotation[] annotations = constructor.getParameterAnnotations()[index];
        boolean required = annotation.required();
        ReferenceDefinition definition = this.createDefinition(name, required, type, implClass, annotations, context);
        ((InjectingComponentType)implementation.getComponentType()).add(definition, (InjectionSite)site);
    }
}

