/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.annotation;

import java.lang.annotation.Annotation;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.annotation.AbstractAnnotationProcessor;
import org.fabric3.spi.introspection.java.annotation.PolicyAnnotationProcessor;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.policy.OperationPolicyIntrospector;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.osoa.sca.annotations.Constructor;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Service;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceProcessor<I extends Implementation<? extends InjectingComponentType>>
extends AbstractAnnotationProcessor<Service, I> {
    private final JavaContractProcessor contractProcessor;
    private OperationPolicyIntrospector policyIntrospector;
    private PolicyAnnotationProcessor policyProcessor;

    public ServiceProcessor(JavaContractProcessor contractProcessor) {
        super(Service.class);
        this.contractProcessor = contractProcessor;
    }

    @Constructor
    public ServiceProcessor(@Reference JavaContractProcessor contractProcessor, @Reference OperationPolicyIntrospector policyIntrospector) {
        super(Service.class);
        this.contractProcessor = contractProcessor;
        this.policyIntrospector = policyIntrospector;
    }

    @Reference
    public void setPolicyProcessor(PolicyAnnotationProcessor processor) {
        this.policyProcessor = processor;
    }

    public void visitType(Service annotation, Class<?> type, I implementation, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        for (Class service : annotation.interfaces()) {
            ServiceDefinition definition = this.createDefinition(service, type, context);
            componentType.add(definition);
        }
        Class service = annotation.value();
        if (!Void.class.equals((Object)service)) {
            ServiceDefinition definition = this.createDefinition(service, type, context);
            componentType.add(definition);
        }
    }

    private ServiceDefinition createDefinition(Class<?> service, Class<?> implClass, IntrospectionContext context) {
        JavaServiceContract serviceContract = this.contractProcessor.introspect(service, implClass, context);
        ServiceDefinition definition = new ServiceDefinition(serviceContract.getInterfaceName(), (ServiceContract)serviceContract);
        Annotation[] annotations = service.getAnnotations();
        if (this.policyProcessor != null) {
            for (Annotation annotation : annotations) {
                this.policyProcessor.process(annotation, (PolicyAware)definition, context);
            }
            this.policyIntrospector.introspectPolicyOnOperations((ServiceContract)serviceContract, implClass, context);
        }
        return definition;
    }
}

