/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.introspection.java.contract;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.jws.WebMethod;
import javax.xml.namespace.QName;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.introspection.java.contract.InvalidCallbackContract;
import org.fabric3.introspection.java.contract.InvalidConversationalOperation;
import org.fabric3.introspection.java.contract.MissingCallback;
import org.fabric3.introspection.java.contract.OverloadedOperation;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.InterfaceIntrospector;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.introspection.java.contract.OperationIntrospector;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.java.JavaGenericType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.fabric3.spi.model.type.java.JavaTypeInfo;
import org.osoa.sca.annotations.Callback;
import org.osoa.sca.annotations.Conversational;
import org.osoa.sca.annotations.EndsConversation;
import org.osoa.sca.annotations.OneWay;
import org.osoa.sca.annotations.Reference;
import org.osoa.sca.annotations.Remotable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaContractProcessorImpl
implements JavaContractProcessor {
    public static final QName ONEWAY_INTENT = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "oneWay");
    private final IntrospectionHelper helper;
    private List<InterfaceIntrospector> interfaceIntrospectors;
    private List<OperationIntrospector> operationIntrospectors;

    public JavaContractProcessorImpl(@Reference IntrospectionHelper helper) {
        this.helper = helper;
        this.interfaceIntrospectors = new ArrayList<InterfaceIntrospector>();
        this.operationIntrospectors = new ArrayList<OperationIntrospector>();
    }

    @Reference(required=false)
    public void setInterfaceIntrospectors(List<InterfaceIntrospector> interfaceIntrospectors) {
        this.interfaceIntrospectors = interfaceIntrospectors;
    }

    @Reference(required=false)
    public void setOperationIntrospectors(List<OperationIntrospector> operationIntrospectors) {
        this.operationIntrospectors = operationIntrospectors;
    }

    public JavaServiceContract introspect(Class<?> interfaze, IntrospectionContext context) {
        return this.introspect(interfaze, interfaze, context);
    }

    public JavaServiceContract introspect(Class<?> interfaze, Class<?> baseClass, IntrospectionContext context) {
        JavaServiceContract contract = this.introspectInterface(interfaze, baseClass, context);
        Callback callback = interfaze.getAnnotation(Callback.class);
        if (callback != null) {
            Class callbackClass = callback.value();
            this.introspectCallback(interfaze, callbackClass, contract, context);
        } else {
            org.oasisopen.sca.annotation.Callback oasisCallback = interfaze.getAnnotation(org.oasisopen.sca.annotation.Callback.class);
            if (oasisCallback != null) {
                Class callbackClass = oasisCallback.value();
                this.introspectCallback(interfaze, callbackClass, contract, context);
            }
        }
        return contract;
    }

    private void introspectCallback(Class<?> interfaze, Class<?> callbackClass, JavaServiceContract contract, IntrospectionContext context) {
        if (Void.class.equals(callbackClass)) {
            context.addError((ValidationFailure)new MissingCallback(interfaze));
            return;
        }
        JavaServiceContract callbackContract = this.introspectInterface(callbackClass, callbackClass, context);
        if (contract.isRemotable() != callbackContract.isRemotable()) {
            String forwardName = contract.getInterfaceName();
            String callbackName = callbackContract.getInterfaceName();
            InvalidCallbackContract error = new InvalidCallbackContract("The remotable attribute on the forward and callback contract do not match: " + forwardName + "," + callbackName);
            context.addError((ValidationFailure)error);
        }
        contract.setCallbackContract((ServiceContract)callbackContract);
    }

    private JavaServiceContract introspectInterface(Class<?> interfaze, Class<?> baseClass, IntrospectionContext context) {
        JavaServiceContract contract = new JavaServiceContract(interfaze);
        contract.setInterfaceName(interfaze.getSimpleName());
        boolean remotable = interfaze.isAnnotationPresent(org.oasisopen.sca.annotation.Remotable.class) || interfaze.isAnnotationPresent(Remotable.class);
        contract.setRemotable(remotable);
        boolean conversational = this.helper.isAnnotationPresent(interfaze, Conversational.class);
        contract.setConversational(conversational);
        List<Operation> operations = this.introspectOperations(interfaze, baseClass, remotable, conversational, context);
        contract.setOperations(operations);
        for (InterfaceIntrospector introspector : this.interfaceIntrospectors) {
            introspector.introspect((ServiceContract)contract, interfaze, context);
        }
        return contract;
    }

    private List<Operation> introspectOperations(Class<?> interfaze, Class<?> baseClass, boolean remotable, boolean conversational, IntrospectionContext context) {
        Method[] methods = interfaze.getMethods();
        ArrayList<Operation> operations = new ArrayList<Operation>(methods.length);
        for (Method method : methods) {
            WebMethod webMethod;
            String name = method.getName();
            TypeMapping typeMapping = this.getTypeMapping(interfaze, baseClass, context);
            DataType<?> returnType = this.introspectReturnType(method, typeMapping);
            List<DataType<?>> paramTypes = this.introspectParameterTypes(method, typeMapping);
            List<DataType<?>> faultTypes = this.introspectFaultTypes(method, typeMapping);
            int conversationSequence = this.introspectConversationSequence(conversational, method, context);
            Operation operation = new Operation(name, paramTypes, returnType, faultTypes, conversationSequence);
            operation.setRemotable(remotable);
            if (method.isAnnotationPresent(org.oasisopen.sca.annotation.OneWay.class) || method.isAnnotationPresent(OneWay.class)) {
                operation.addIntent(ONEWAY_INTENT);
            }
            if ((webMethod = method.getAnnotation(WebMethod.class)) != null && webMethod.operationName().length() > 0) {
                operation.setWsdlName(webMethod.operationName());
            }
            for (OperationIntrospector introspector : this.operationIntrospectors) {
                introspector.introspect(operation, method, context);
            }
            if (remotable) {
                this.checkOverloadedOperations(method, operations, context);
            }
            operations.add(operation);
        }
        return operations;
    }

    private DataType<?> introspectReturnType(Method method, TypeMapping typeMapping) {
        Class<?> physicalReturnType = method.getReturnType();
        Type gReturnType = method.getGenericReturnType();
        Type logicalReturnType = typeMapping.getActualType(gReturnType);
        return this.createDataType(physicalReturnType, logicalReturnType, typeMapping);
    }

    private List<DataType<?>> introspectParameterTypes(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalParameterTypes = method.getParameterTypes();
        Type[] gParamTypes = method.getGenericParameterTypes();
        ArrayList parameterDataTypes = new ArrayList(gParamTypes.length);
        for (int i = 0; i < gParamTypes.length; ++i) {
            Type gParamType = gParamTypes[i];
            Type logicalParamType = typeMapping.getActualType(gParamType);
            DataType<?> dataType = this.createDataType(physicalParameterTypes[i], logicalParamType, typeMapping);
            parameterDataTypes.add(dataType);
        }
        return parameterDataTypes;
    }

    private List<DataType<?>> introspectFaultTypes(Method method, TypeMapping typeMapping) {
        Class<?>[] physicalFaultTypes = method.getExceptionTypes();
        Type[] gFaultTypes = method.getGenericExceptionTypes();
        ArrayList faultDataTypes = new ArrayList(gFaultTypes.length);
        for (int i = 0; i < gFaultTypes.length; ++i) {
            Type gFaultType = gFaultTypes[i];
            Type logicalType = typeMapping.getActualType(gFaultType);
            DataType<?> dataType = this.createDataType(physicalFaultTypes[i], logicalType, typeMapping);
            faultDataTypes.add(dataType);
        }
        return faultDataTypes;
    }

    private TypeMapping getTypeMapping(Class<?> type, Class<?> baseClass, IntrospectionContext context) {
        TypeMapping typeMapping = context.getTypeMapping(baseClass);
        if (typeMapping == null) {
            typeMapping = new TypeMapping();
            context.addTypeMapping(type, typeMapping);
            this.helper.resolveTypeParameters(type, typeMapping);
        }
        return typeMapping;
    }

    private int introspectConversationSequence(boolean conversational, Method method, IntrospectionContext context) {
        int conversationSequence = -1;
        if (method.isAnnotationPresent(EndsConversation.class)) {
            if (!conversational) {
                context.addError((ValidationFailure)new InvalidConversationalOperation(method));
            }
            conversationSequence = 2;
        } else if (conversational) {
            conversationSequence = 1;
        }
        return conversationSequence;
    }

    private DataType<?> createDataType(Class<?> physicalType, Type type, TypeMapping mapping) {
        if (type instanceof Class) {
            return new JavaClass(physicalType);
        }
        JavaTypeInfo info = this.helper.createTypeInfo(type, mapping);
        return new JavaGenericType(info);
    }

    private void checkOverloadedOperations(Method method, List<Operation> operations, IntrospectionContext context) {
        for (Operation entry : operations) {
            String name = method.getName();
            if (!entry.getName().equals(name)) continue;
            OverloadedOperation error = new OverloadedOperation(name);
            context.addError((ValidationFailure)error);
        }
    }
}

