/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.introspection;

import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.host.monitor.MonitorEvent;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.ConsumerDefinition;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.monitor.model.MonitorImplementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.fabric3.spi.model.type.java.JavaClass;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class MonitorImplementationLoader
implements TypeLoader<MonitorImplementation> {
    private List<DataType<?>> consumerTypes;
    private LoaderHelper helper;

    public MonitorImplementationLoader(@Reference LoaderHelper helper) {
        this.helper = helper;
        this.consumerTypes = new ArrayList();
        this.consumerTypes.add((DataType<?>)new JavaClass(MonitorEvent.class));
    }

    public MonitorImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        this.validateAttributes(reader, introspectionContext);
        reader.next();
        Element configuration = null;
        if (reader.getName().getLocalPart().contains("configuration")) {
            NodeList list;
            Document document = this.helper.transform(reader);
            if (document != null && (list = document.getElementsByTagName("configuration")).getLength() == 1) {
                configuration = (Element)list.item(0);
            }
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        }
        ComponentType type = new ComponentType();
        type.add(new ConsumerDefinition("monitor", this.consumerTypes));
        return new MonitorImplementation(type, configuration);
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

