/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.host.monitor.MonitorCreationException;
import org.fabric3.host.monitor.MonitorProxyService;
import org.fabric3.host.monitor.Monitorable;
import org.fabric3.monitor.runtime.ChannelNotFoundException;
import org.fabric3.monitor.runtime.DispatchInfo;
import org.fabric3.monitor.runtime.MonitorHandler;
import org.fabric3.spi.channel.Channel;
import org.fabric3.spi.channel.ChannelManager;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.channel.PassThroughHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDKMonitorProxyService
implements MonitorProxyService {
    private ChannelManager channelManager;
    private Monitorable defaultMonitorable;

    public JDKMonitorProxyService(Monitorable monitorable, ChannelManager channelManager) {
        this.defaultMonitorable = monitorable;
        this.channelManager = channelManager;
    }

    public <T> T createMonitor(Class<T> type, URI channelUri) throws MonitorCreationException {
        return this.createMonitor(type, this.defaultMonitorable, channelUri);
    }

    public <T> T createMonitor(Class<T> type, Monitorable monitorable, URI channelUri) throws MonitorCreationException {
        Channel channel = this.channelManager.getChannel(channelUri);
        if (channel == null) {
            throw new ChannelNotFoundException("Channel not found");
        }
        PassThroughHandler streamHandler = new PassThroughHandler();
        channel.attach((EventStreamHandler)streamHandler);
        ClassLoader loader = type.getClassLoader();
        ResourceBundle bundle = this.locateBundle(type, "f3", loader);
        HashMap<String, DispatchInfo> levels = new HashMap<String, DispatchInfo>();
        for (Method method : type.getMethods()) {
            MonitorLevel level = MonitorLevel.getAnnotatedLogLevel((Method)method);
            String key = type.getName() + "#" + method.getName();
            String message = null;
            if (bundle != null) {
                try {
                    message = bundle.getString(key);
                }
                catch (MissingResourceException e) {
                    // empty catch block
                }
            }
            if (message == null && method.getParameterTypes().length == 0) {
                message = key;
            }
            levels.put(method.getName(), new DispatchInfo(level, message));
        }
        MonitorHandler handler = new MonitorHandler(monitorable, (EventStreamHandler)streamHandler, levels);
        return type.cast(Proxy.newProxyInstance(loader, new Class[]{type}, (InvocationHandler)handler));
    }

    private <T> ResourceBundle locateBundle(Class<T> monitorInterface, String bundleName, ClassLoader loader) {
        Locale locale = Locale.getDefault();
        String packageName = monitorInterface.getPackage().getName();
        while (true) {
            try {
                return ResourceBundle.getBundle(packageName + '.' + bundleName, locale, loader);
            }
            catch (MissingResourceException e) {
                int index = packageName.lastIndexOf(46);
                if (index != -1) {
                    packageName = packageName.substring(0, index);
                    continue;
                }
                try {
                    return ResourceBundle.getBundle(bundleName, locale, loader);
                }
                catch (Exception e2) {
                    return null;
                }
            }
            break;
        }
    }
}

