/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import java.net.URI;
import java.util.List;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.management.Management;
import org.fabric3.api.annotation.management.ManagementOperation;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.monitor.runtime.LevelConverter;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.monitor.MonitorService;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Init;
import org.osoa.sca.annotations.Property;
import org.osoa.sca.annotations.Reference;
import org.slf4j.LoggerFactory;

@EagerInit
@Management(name="MonitorService", description="Sets monitoring levels for the runtime")
public class LogBackMonitorService
implements MonitorService {
    private ComponentManager manager;
    private MonitorLevel defaultLevel = MonitorLevel.WARNING;

    public LogBackMonitorService(@Reference ComponentManager manager) {
        this.manager = manager;
    }

    @Property
    public void setDefaultLevel(String defaultLevel) {
        this.defaultLevel = MonitorLevel.valueOf((String)defaultLevel);
    }

    @Init
    public void init() {
        Level level = LevelConverter.getLogbackLevel(this.defaultLevel);
        ((Logger)LoggerFactory.getLogger((String)"ROOT")).setLevel(level);
    }

    @ManagementOperation(description="Sets the monitoring level for a component")
    public void setComponentLevel(String uri, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level);
        List components = this.manager.getComponentsInHierarchy(URI.create(uri));
        for (Component component : components) {
            component.setLevel(parsed);
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a deployable composite")
    public void setDeployableLevel(String deployable, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level);
        List components = this.manager.getDeployedComponents(QName.valueOf(deployable));
        for (Component component : components) {
            component.setLevel(parsed);
        }
    }

    @ManagementOperation(description="Sets the monitoring level for a provider")
    public void setProviderLevel(String key, String level) {
        MonitorLevel parsed = MonitorLevel.valueOf((String)level);
        Level logBackLevel = LevelConverter.getLogbackLevel(parsed);
        ((Logger)LoggerFactory.getLogger((String)key)).setLevel(logBackLevel);
    }
}

