/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.monitor.MonitorEvent;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class LogbackDispatcher
implements MonitorEventDispatcher {
    private static final String DEFAULT_PATTERN = "[%level %thread %d{YY:MM:DD HH:mm:ss.SSS}] %msg%n%ex";
    private boolean configured;
    private LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
    private Logger logger;

    public LogbackDispatcher(String name) {
        this(name, false);
    }

    public LogbackDispatcher(String name, boolean additive) {
        this.logger = this.context.getLogger(name);
        this.logger.setAdditive(additive);
    }

    public void configure(Element element) throws MonitorConfigurationException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            document.adoptNode(element);
            document.appendChild(element);
            InputSource source = this.transform(document);
            this.logger.detachAndStopAllAppenders();
            JoranConfigurator configurator = new JoranConfigurator();
            configurator.setContext((Context)this.context);
            configurator.doConfigure(source);
            this.configured = true;
        }
        catch (ParserConfigurationException e) {
            throw new MonitorConfigurationException("Error parsing monitor configuration", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new MonitorConfigurationException("Error parsing monitor configuration", (Throwable)e);
        }
        catch (JoranException e) {
            throw new MonitorConfigurationException("Error parsing monitor configuration", (Throwable)e);
        }
    }

    public void start() {
        if (!this.configured) {
            this.configureDefaultAppender(this.context);
        }
    }

    public void stop() {
        this.context.stop();
    }

    public void onEvent(MonitorEvent event) {
        if (!(event instanceof ILoggingEvent)) {
            throw new AssertionError((Object)("Event must implement " + ILoggingEvent.class.getName()));
        }
        this.logger.callAppenders((ILoggingEvent)event);
    }

    private void configureDefaultAppender(LoggerContext context) {
        this.logger.detachAndStopAllAppenders();
        ConsoleAppender appender = new ConsoleAppender();
        appender.setContext((Context)context);
        appender.setName("fabric3-console");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern(DEFAULT_PATTERN);
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.start();
        this.logger.addAppender((Appender)appender);
    }

    private InputSource transform(Document document) throws TransformerException {
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        DOMSource source = new DOMSource(document);
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(stream);
        transformer.transform(source, result);
        return new InputSource(new ByteArrayInputStream(stream.toByteArray()));
    }

    static {
        ((LoggerContext)LoggerFactory.getILoggerFactory()).getLogger("ROOT").detachAndStopAllAppenders();
    }
}

