/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.channel.EventStream;
import org.fabric3.spi.channel.EventStreamHandler;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.monitor.DispatcherWrapper;

public class MonitorComponent
implements Component {
    private URI uri;
    private QName deployable;
    private URI classLoaderId;
    private MonitorLevel level;
    private MonitorEventDispatcher dispatcher;
    private EventStreamHandler handler;

    public MonitorComponent(URI uri, QName deployable, MonitorEventDispatcher dispatcher) {
        this.uri = uri;
        this.deployable = deployable;
        this.dispatcher = dispatcher;
        this.handler = new DispatcherWrapper(dispatcher);
    }

    public QName getDeployable() {
        return this.deployable;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getClassLoaderId() {
        return this.classLoaderId;
    }

    public void setClassLoaderId(URI classLoaderId) {
        this.classLoaderId = classLoaderId;
    }

    public String getName() {
        return this.uri.toString();
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void start() {
        this.dispatcher.start();
    }

    public void stop() {
        this.dispatcher.stop();
    }

    public void attach(ChannelConnection connection) {
        for (EventStream stream : connection.getEventStreams()) {
            stream.addHandler(this.handler);
        }
    }
}

