/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.host.monitor.MonitorConfigurationException;
import org.fabric3.host.monitor.MonitorEventDispatcher;
import org.fabric3.host.monitor.MonitorEventDispatcherFactory;
import org.fabric3.monitor.provision.MonitorComponentDefinition;
import org.fabric3.monitor.runtime.MonitorComponent;
import org.fabric3.monitor.runtime.MonitorComponentBuildException;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.builder.component.ComponentBuilder;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class MonitorComponentBuilder
implements ComponentBuilder<MonitorComponentDefinition, MonitorComponent> {
    private MonitorEventDispatcherFactory factory;

    public MonitorComponentBuilder(@Reference MonitorEventDispatcherFactory factory) {
        this.factory = factory;
    }

    public MonitorComponent build(MonitorComponentDefinition definition) throws BuilderException {
        URI uri = definition.getComponentUri();
        QName deployable = definition.getDeployable();
        Element configuration = definition.getConfiguration();
        try {
            MonitorEventDispatcher dispatcher = this.factory.createInstance(uri.toString(), configuration);
            return new MonitorComponent(uri, deployable, dispatcher);
        }
        catch (MonitorConfigurationException e) {
            throw new MonitorComponentBuildException(e);
        }
    }

    public void dispose(MonitorComponentDefinition definition, MonitorComponent component) throws BuilderException {
    }
}

