/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Map;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.host.monitor.Monitorable;
import org.fabric3.monitor.runtime.DispatchInfo;
import org.fabric3.monitor.runtime.MonitorEventImpl;
import org.fabric3.spi.channel.EventStreamHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorHandler
implements InvocationHandler {
    private static final Object[] EMPTY_DATA = new Object[0];
    private Monitorable monitorable;
    private String runtime;
    private String source;
    private EventStreamHandler streamHandler;
    private MonitorLevel level;
    private String message;
    private Map<String, DispatchInfo> infos;

    public MonitorHandler(Monitorable monitorable, EventStreamHandler streamHandler, Map<String, DispatchInfo> infos) {
        this.monitorable = monitorable;
        this.source = monitorable.getName();
        this.streamHandler = streamHandler;
        this.infos = infos;
        if (infos.size() == 1) {
            DispatchInfo info = infos.values().iterator().next();
            this.level = info.getLevel();
            this.message = info.getMessage();
        }
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String currentMessage;
        MonitorLevel currentLevel;
        if (this.level != null) {
            currentLevel = this.level;
            currentMessage = this.message;
        } else {
            DispatchInfo info = this.infos.get(method.getName());
            currentLevel = info.getLevel();
            currentMessage = info.getMessage();
        }
        if (currentLevel == null || currentLevel.intValue() < this.monitorable.getLevel().intValue()) {
            return null;
        }
        String thread = Thread.currentThread().getName();
        currentMessage = this.format(currentMessage, args);
        long time = System.currentTimeMillis();
        if (args == null) {
            args = EMPTY_DATA;
        }
        MonitorEventImpl event = new MonitorEventImpl(this.runtime, this.source, currentLevel, time, thread, currentMessage, args);
        Object[] param = new Object[]{event};
        this.streamHandler.handle((Object)param);
        return null;
    }

    private String format(String message, Object[] args) {
        if (message == null) {
            StringBuilder builder = new StringBuilder();
            for (Object arg : args) {
                builder.append(arg).append(" ");
            }
            return builder.toString();
        }
        if (args != null && args.length != 0 && (message.indexOf("{0") >= 0 || message.indexOf("{1") >= 0 || message.indexOf("{2") >= 0 || message.indexOf("{3") >= 0)) {
            return MessageFormat.format(message, args);
        }
        return message;
    }
}

