/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.monitor.runtime;

import org.fabric3.host.monitor.MonitorCreationException;
import org.fabric3.host.monitor.MonitorProxyService;
import org.fabric3.host.monitor.Monitorable;
import org.fabric3.monitor.provision.MonitorTargetDefinition;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.SingletonObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitorWireAttacher
implements TargetWireAttacher<MonitorTargetDefinition> {
    private final MonitorProxyService monitorService;
    private ComponentManager componentManager;
    private final ClassLoaderRegistry classLoaderRegistry;

    public MonitorWireAttacher(@Reference MonitorProxyService monitorService, @Reference ComponentManager componentManager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.monitorService = monitorService;
        this.componentManager = componentManager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalSourceDefinition source, MonitorTargetDefinition target, Wire wire) throws WiringException {
        throw new UnsupportedOperationException();
    }

    public void detach(PhysicalSourceDefinition source, MonitorTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }

    public ObjectFactory<?> createObjectFactory(MonitorTargetDefinition target) throws WiringException {
        try {
            ClassLoader loader = this.classLoaderRegistry.getClassLoader(target.getClassLoaderId());
            Class type = this.classLoaderRegistry.loadClass(loader, target.getMonitorType());
            Component monitorable = this.componentManager.getComponent(target.getMonitorable());
            Object monitor = this.monitorService.createMonitor(type, (Monitorable)monitorable, target.getUri());
            return new SingletonObjectFactory(monitor);
        }
        catch (ClassNotFoundException e) {
            throw new WireAttachException("Unable to load monitor class: " + target.getMonitorType(), (Throwable)e);
        }
        catch (MonitorCreationException e) {
            throw new WireAttachException("Unable to create monitor for class: " + target.getMonitorType(), (Throwable)e);
        }
    }
}

