/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import java.lang.reflect.Constructor;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.NoConstructorFound;
import org.fabric3.spi.introspection.java.annotation.AmbiguousConstructor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemConstructorHeuristic
implements HeuristicProcessor<SystemImplementation> {
    public void applyHeuristics(SystemImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        if (componentType.getConstructor() != null) {
            return;
        }
        Signature signature = this.findConstructor(implClass, context);
        componentType.setConstructor(signature);
    }

    Signature findConstructor(Class<?> implClass, IntrospectionContext context) {
        Constructor<?>[] constructors = implClass.getDeclaredConstructors();
        Constructor<?> selected = null;
        if (constructors.length == 1) {
            selected = constructors[0];
        } else {
            for (Constructor<?> constructor : constructors) {
                if (!constructor.isAnnotationPresent(org.osoa.sca.annotations.Constructor.class)) continue;
                if (selected != null) {
                    context.addError((ValidationFailure)new AmbiguousConstructor(implClass));
                    return null;
                }
                selected = constructor;
            }
            if (selected == null) {
                try {
                    selected = implClass.getConstructor(new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    context.addError((ValidationFailure)new NoConstructorFound(implClass));
                    return null;
                }
            }
        }
        return new Signature(selected);
    }
}

