/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemHeuristic
implements HeuristicProcessor<SystemImplementation> {
    private final HeuristicProcessor<SystemImplementation> serviceHeuristic;
    private final HeuristicProcessor<SystemImplementation> constructorHeuristic;
    private final HeuristicProcessor<SystemImplementation> injectionHeuristic;

    public SystemHeuristic(@Reference(name="service") HeuristicProcessor<SystemImplementation> serviceHeuristic, @Reference(name="constructor") HeuristicProcessor<SystemImplementation> constructorHeuristic, @Reference(name="injection") HeuristicProcessor<SystemImplementation> injectionHeuristic) {
        this.serviceHeuristic = serviceHeuristic;
        this.constructorHeuristic = constructorHeuristic;
        this.injectionHeuristic = injectionHeuristic;
    }

    public void applyHeuristics(SystemImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        this.serviceHeuristic.applyHeuristics((Implementation)implementation, implClass, context);
        this.constructorHeuristic.applyHeuristics((Implementation)implementation, implClass, context);
        this.injectionHeuristic.applyHeuristics((Implementation)implementation, implClass, context);
    }
}

