/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.introspection.xml.TypeLoader;
import org.fabric3.spi.introspection.xml.UnrecognizedAttribute;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SystemImplementationLoader
implements TypeLoader<SystemImplementation> {
    private final ImplementationProcessor<SystemImplementation> implementationProcessor;

    public SystemImplementationLoader(@Reference ImplementationProcessor<SystemImplementation> implementationProcessor) {
        this.implementationProcessor = implementationProcessor;
    }

    public SystemImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        assert (SystemImplementation.IMPLEMENTATION_SYSTEM.equals(reader.getName()));
        this.validateAttributes(reader, introspectionContext);
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("Implementation class must be specified using the class attribute", reader);
            introspectionContext.addError((ValidationFailure)failure);
            return null;
        }
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        SystemImplementation implementation = new SystemImplementation();
        implementation.setImplementationClass(implClass);
        this.implementationProcessor.introspect((Implementation)implementation, introspectionContext);
        return implementation;
    }

    private void validateAttributes(XMLStreamReader reader, IntrospectionContext context) {
        for (int i = 0; i < reader.getAttributeCount(); ++i) {
            String name = reader.getAttributeLocalName(i);
            if ("class".equals(name)) continue;
            context.addError((ValidationFailure)new UnrecognizedAttribute(name, reader));
        }
    }
}

