/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.Implementation;
import org.fabric3.spi.introspection.ImplementationNotFoundException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.ImplementationProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidImplementation;
import org.fabric3.spi.introspection.java.MissingResource;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemImplementationProcessorImpl
implements ImplementationProcessor<SystemImplementation> {
    private final ClassVisitor<SystemImplementation> classVisitor;
    private final HeuristicProcessor<SystemImplementation> heuristic;
    private final IntrospectionHelper helper;

    public SystemImplementationProcessorImpl(@Reference(name="classVisitor") ClassVisitor<SystemImplementation> classVisitor, @Reference(name="heuristic") HeuristicProcessor<SystemImplementation> heuristic, @Reference(name="helper") IntrospectionHelper helper) {
        this.classVisitor = classVisitor;
        this.heuristic = heuristic;
        this.helper = helper;
    }

    public void introspect(SystemImplementation implementation, IntrospectionContext context) {
        Class implClass;
        String implClassName = implementation.getImplementationClass();
        InjectingComponentType componentType = new InjectingComponentType(implClassName);
        componentType.setScope("COMPOSITE");
        implementation.setComponentType((ComponentType)componentType);
        ClassLoader cl = context.getClassLoader();
        try {
            implClass = this.helper.loadClass(implClassName, cl);
        }
        catch (ImplementationNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError) {
                context.addError((ValidationFailure)new MissingResource("Class referenced from system implementation not found on classpath", e.getCause().getMessage()));
            } else {
                context.addError((ValidationFailure)new MissingResource("System implementation class not found on classpath", implClassName));
            }
            return;
        }
        if (implClass.isInterface()) {
            InvalidImplementation failure = new InvalidImplementation("Implementation class is an interface", implClassName);
            context.addError((ValidationFailure)failure);
            return;
        }
        TypeMapping mapping = context.getTypeMapping(implClass);
        if (mapping == null) {
            mapping = new TypeMapping();
            context.addTypeMapping(implClass, mapping);
            this.helper.resolveTypeParameters(implClass, mapping);
        }
        this.classVisitor.visit((Implementation)implementation, implClass, context);
        this.heuristic.applyHeuristics((Implementation)implementation, implClass, context);
    }
}

