/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.introspection;

import java.util.Set;
import org.fabric3.implementation.system.model.SystemImplementation;
import org.fabric3.model.type.component.ServiceDefinition;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.contract.JavaContractProcessor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.JavaServiceContract;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SystemServiceHeuristic
implements HeuristicProcessor<SystemImplementation> {
    private final JavaContractProcessor contractProcessor;
    private final IntrospectionHelper helper;

    public SystemServiceHeuristic(@Reference JavaContractProcessor contractProcessor, @Reference IntrospectionHelper helper) {
        this.contractProcessor = contractProcessor;
        this.helper = helper;
    }

    public void applyHeuristics(SystemImplementation implementation, Class<?> implClass, IntrospectionContext context) {
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        if (componentType.getServices().isEmpty()) {
            Set interfaces = this.helper.getImplementedInterfaces(implClass);
            if (interfaces.isEmpty()) {
                ServiceDefinition serviceDefinition = this.createServiceDefinition(implClass, context);
                componentType.add(serviceDefinition);
            } else {
                for (Class serviceInterface : interfaces) {
                    ServiceDefinition serviceDefinition = this.createServiceDefinition(serviceInterface, context);
                    componentType.add(serviceDefinition);
                }
            }
        }
    }

    private ServiceDefinition createServiceDefinition(Class<?> serviceInterface, IntrospectionContext context) {
        JavaServiceContract contract = this.contractProcessor.introspect(serviceInterface, context);
        return new ServiceDefinition(contract.getInterfaceName(), (ServiceContract)contract);
    }
}

