/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.net.URI;
import javax.xml.namespace.QName;
import org.fabric3.implementation.pojo.builder.PojoComponentBuilder;
import org.fabric3.implementation.pojo.builder.PropertyObjectFactoryBuilder;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryBuilder;
import org.fabric3.implementation.pojo.instancefactory.InstanceFactoryProvider;
import org.fabric3.implementation.pojo.provision.InstanceFactoryDefinition;
import org.fabric3.implementation.system.provision.SystemComponentDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.builder.BuilderException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.component.ScopeRegistry;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.management.ManagementService;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SystemComponentBuilder
extends PojoComponentBuilder<SystemComponentDefinition, SystemComponent> {
    private ScopeRegistry scopeRegistry;
    private InstanceFactoryBuilder factoryBuilder;

    public SystemComponentBuilder(@Reference ScopeRegistry scopeRegistry, @Reference InstanceFactoryBuilder factoryBuilder, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference PropertyObjectFactoryBuilder propertyBuilder, @Reference ManagementService managementService, @Reference IntrospectionHelper helper) {
        super(classLoaderRegistry, propertyBuilder, managementService, helper);
        this.scopeRegistry = scopeRegistry;
        this.factoryBuilder = factoryBuilder;
    }

    public SystemComponent build(SystemComponentDefinition definition) throws BuilderException {
        URI uri = definition.getComponentUri();
        QName deployable = definition.getDeployable();
        ClassLoader classLoader = this.classLoaderRegistry.getClassLoader(definition.getClassLoaderId());
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(Scope.COMPOSITE);
        InstanceFactoryDefinition factoryDefinition = definition.getFactoryDefinition();
        InstanceFactoryProvider provider = this.factoryBuilder.build(factoryDefinition, classLoader);
        this.createPropertyFactories(definition, provider);
        boolean eager = definition.isEagerInit();
        SystemComponent component = new SystemComponent(uri, provider, scopeContainer, deployable, eager, -1, -1);
        this.export(definition, classLoader, (AtomicComponent)component);
        return component;
    }

    public void dispose(SystemComponentDefinition definition, SystemComponent component) throws BuilderException {
        this.dispose(definition);
    }
}

