/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.List;
import org.fabric3.implementation.system.provision.SystemTargetDefinition;
import org.fabric3.implementation.system.runtime.SystemComponent;
import org.fabric3.implementation.system.runtime.SystemInvokerInterceptor;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.osoa.sca.annotations.EagerInit;
import org.osoa.sca.annotations.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class SystemTargetWireAttacher
implements TargetWireAttacher<SystemTargetDefinition> {
    private final ComponentManager manager;
    private final ClassLoaderRegistry classLoaderRegistry;

    public SystemTargetWireAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalSourceDefinition source, SystemTargetDefinition target, Wire wire) throws WiringException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        SystemComponent targetComponent = (SystemComponent)this.manager.getComponent(targetId);
        ScopeContainer scopeContainer = targetComponent.getScopeContainer();
        Class implementationClass = targetComponent.getImplementationClass();
        ClassLoader loader = implementationClass.getClassLoader();
        for (InvocationChain chain : wire.getInvocationChains()) {
            Method method;
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            List params = operation.getSourceParameterTypes();
            Class[] paramTypes = new Class[params.size()];
            for (int i = 0; i < params.size(); ++i) {
                String param = (String)params.get(i);
                try {
                    paramTypes[i] = this.classLoaderRegistry.loadClass(loader, param);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    URI sourceUri = source.getUri();
                    URI targetUri = target.getUri();
                    throw new WireAttachException("Implementation class not found", sourceUri, targetUri, (Throwable)e);
                }
            }
            try {
                method = implementationClass.getMethod(operation.getName(), paramTypes);
            }
            catch (NoSuchMethodException e) {
                URI sourceUri = source.getUri();
                URI targetUri = target.getUri();
                throw new WireAttachException("No matching method found", sourceUri, targetUri, (Throwable)e);
            }
            SystemInvokerInterceptor interceptor = new SystemInvokerInterceptor(method, scopeContainer, (AtomicComponent)targetComponent);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalSourceDefinition source, SystemTargetDefinition target) throws WiringException {
        throw new AssertionError();
    }

    public ObjectFactory<?> createObjectFactory(SystemTargetDefinition target) throws WiringException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        SystemComponent targetComponent = (SystemComponent)this.manager.getComponent(targetId);
        return targetComponent.createObjectFactory();
    }
}

