/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.system.singleton;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.fabric3.api.annotation.monitor.MonitorLevel;
import org.fabric3.spi.ObjectCreationException;
import org.fabric3.spi.ObjectFactory;
import org.fabric3.spi.SingletonObjectFactory;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.InstanceDestructionException;
import org.fabric3.spi.component.InstanceInitializationException;
import org.fabric3.spi.component.InstanceWrapper;
import org.fabric3.spi.invocation.WorkContext;
import org.fabric3.spi.model.type.java.FieldInjectionSite;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.MethodInjectionSite;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SingletonComponent
implements AtomicComponent {
    private final URI uri;
    private Object instance;
    private Map<Member, Injectable> sites;
    private InstanceWrapper wrapper;
    private Map<ObjectFactory, Injectable> reinjectionMappings;
    private URI classLoaderId;
    private MonitorLevel level = MonitorLevel.INFO;

    public SingletonComponent(URI componentId, Object instance, Map<InjectionSite, Injectable> mappings) {
        this.uri = componentId;
        this.instance = instance;
        this.wrapper = new SingletonWrapper(instance);
        this.reinjectionMappings = new HashMap<ObjectFactory, Injectable>();
        this.initializeInjectionSites(instance, mappings);
    }

    public URI getClassLoaderId() {
        return this.classLoaderId;
    }

    public void setClassLoaderId(URI classLoaderId) {
        this.classLoaderId = classLoaderId;
    }

    public String getKey() {
        return null;
    }

    public URI getUri() {
        return this.uri;
    }

    public void start() {
    }

    public void stop() {
    }

    public QName getDeployable() {
        return null;
    }

    public boolean isEagerInit() {
        return true;
    }

    public long getMaxIdleTime() {
        return -1L;
    }

    public long getMaxAge() {
        return -1L;
    }

    public InstanceWrapper createInstanceWrapper(WorkContext workContext) throws ObjectCreationException {
        return this.wrapper;
    }

    public ObjectFactory<Object> createObjectFactory() {
        return new SingletonObjectFactory(this.instance);
    }

    public String getName() {
        return this.uri.toString();
    }

    public MonitorLevel getLevel() {
        return this.level;
    }

    public void setLevel(MonitorLevel level) {
        this.level = level;
    }

    public void addObjectFactory(Injectable attribute, ObjectFactory paramFactory) {
        this.reinjectionMappings.put(paramFactory, attribute);
    }

    public String toString() {
        return "[" + this.uri.toString() + "] in state [" + super.toString() + ']';
    }

    private void initializeInjectionSites(Object instance, Map<InjectionSite, Injectable> mappings) {
        this.sites = new HashMap<Member, Injectable>();
        for (Map.Entry<InjectionSite, Injectable> entry : mappings.entrySet()) {
            InjectionSite site = entry.getKey();
            if (site instanceof FieldInjectionSite) {
                try {
                    Field field = this.getField(((FieldInjectionSite)site).getName());
                    this.sites.put(field, entry.getValue());
                    continue;
                }
                catch (NoSuchFieldException e) {
                    throw new AssertionError((Object)e);
                }
            }
            if (!(site instanceof MethodInjectionSite)) continue;
            MethodInjectionSite methodInjectionSite = (MethodInjectionSite)site;
            try {
                Method method = methodInjectionSite.getSignature().getMethod(instance.getClass());
                this.sites.put(method, entry.getValue());
            }
            catch (ClassNotFoundException e) {
                throw new AssertionError((Object)e);
            }
            catch (NoSuchMethodException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private Field getField(String name) throws NoSuchFieldException {
        for (Class<?> clazz = this.instance.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                continue;
            }
        }
        throw new NoSuchFieldException(name);
    }

    private class SingletonWrapper
    implements InstanceWrapper {
        private final Object instance;

        private SingletonWrapper(Object instance) {
            this.instance = instance;
        }

        public Object getInstance() {
            return this.instance;
        }

        public boolean isStarted() {
            return true;
        }

        public void start(WorkContext workContext) throws InstanceInitializationException {
        }

        public void stop(WorkContext workContext) throws InstanceDestructionException {
        }

        public void reinject() {
            for (Map.Entry entry : SingletonComponent.this.reinjectionMappings.entrySet()) {
                try {
                    this.inject((Injectable)entry.getValue(), (ObjectFactory)entry.getKey());
                }
                catch (ObjectCreationException e) {
                    throw new AssertionError((Object)e);
                }
            }
            SingletonComponent.this.reinjectionMappings.clear();
        }

        private void inject(Injectable attribute, ObjectFactory factory) throws ObjectCreationException {
            for (Map.Entry entry : SingletonComponent.this.sites.entrySet()) {
                Collection<Object> param;
                if (!((Injectable)entry.getValue()).equals((Object)attribute)) continue;
                Member member = (Member)entry.getKey();
                if (member instanceof Field) {
                    try {
                        param = factory.getInstance();
                        ((Field)member).set(this.instance, param);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new ObjectCreationException((Throwable)e);
                    }
                }
                if (member instanceof Method) {
                    try {
                        param = factory.getInstance();
                        Method method = (Method)member;
                        Class<?> type = method.getParameterTypes()[0];
                        if (Set.class.equals(type)) {
                            param = Collections.singleton(param);
                        } else if (List.class.equals(type)) {
                            param = Collections.singletonList(param);
                        }
                        method.invoke(this.instance, param);
                        continue;
                    }
                    catch (IllegalAccessException e) {
                        throw new ObjectCreationException((Throwable)e);
                    }
                    catch (InvocationTargetException e) {
                        throw new ObjectCreationException((Throwable)e);
                    }
                }
                throw new ObjectCreationException("Unsupported member type" + member);
            }
        }

        public void updated(String referenceName) {
        }

        public void removed(String referenceName) {
        }
    }
}

