/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.channel;

import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fabric3.model.type.contract.DataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventWrapper
implements Serializable {
    private static final long serialVersionUID = 7377714429939143568L;
    private DataType<?> defaultType;
    private final Object defaultEvent;
    private Map<DataType<?>, Object> cache;

    public EventWrapper(DataType<?> type, Object event) {
        this.defaultType = type;
        this.defaultEvent = event;
    }

    public DataType<?> getType() {
        return this.defaultType;
    }

    public Object getEvent() {
        return this.defaultEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> void cache(DataType<T> type, T representation) {
        Object object = this.defaultEvent;
        synchronized (object) {
            if (this.cache == null) {
                this.cache = new ConcurrentHashMap();
                this.cache.put(type, this.defaultEvent);
            }
        }
        this.cache.put(type, representation);
    }

    public Object getEvent(DataType<?> type) {
        if (this.cache != null) {
            return this.cache.get(type);
        }
        if (this.defaultType.equals(type)) {
            return type;
        }
        return null;
    }
}

