/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.contribution.manifest;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.spi.contribution.Export;
import org.fabric3.spi.contribution.Import;
import org.fabric3.spi.contribution.manifest.PackageInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImport
implements Import {
    private static final long serialVersionUID = -7863768515125756048L;
    private static final QName QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "import.java");
    private URI location;
    private PackageInfo packageInfo;
    private Map<URI, Export> resolved;

    public JavaImport(PackageInfo packageInfo) {
        this(packageInfo, null);
    }

    public JavaImport(PackageInfo packageInfo, URI location) {
        if (packageInfo == null) {
            throw new IllegalArgumentException("Package info cannot be null");
        }
        this.packageInfo = packageInfo;
        this.location = location;
        this.resolved = new HashMap<URI, Export>();
    }

    @Override
    public QName getType() {
        return QNAME;
    }

    @Override
    public URI getLocation() {
        return this.location;
    }

    public PackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    @Override
    public boolean isMultiplicity() {
        return false;
    }

    @Override
    public boolean isRequired() {
        return this.packageInfo.isRequired();
    }

    @Override
    public Map<URI, Export> getResolved() {
        return this.resolved;
    }

    @Override
    public void addResolved(URI contributionUri, Export export) {
        if (!this.resolved.isEmpty()) {
            URI entry = this.resolved.keySet().iterator().next();
            String s = "Import [" + this.packageInfo + "] must resolve to only one export. Multiple exporting contributions found: " + entry + " and " + contributionUri;
            throw new IllegalArgumentException(s);
        }
        this.resolved.put(contributionUri, export);
    }

    public String toString() {
        return this.packageInfo.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JavaImport that = (JavaImport)o;
        return !(this.location == null ? that.location != null : !this.location.equals(that.location)) && !(this.packageInfo == null ? that.packageInfo != null : !this.packageInfo.equals(that.packageInfo));
    }

    public int hashCode() {
        int result = this.location != null ? this.location.hashCode() : 0;
        result = 31 * result + (this.packageInfo != null ? this.packageInfo.hashCode() : 0);
        return result;
    }
}

