/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection;

import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultIntrospectionContext
implements IntrospectionContext {
    private List<ValidationFailure> errors = new ArrayList<ValidationFailure>();
    private List<ValidationFailure> warnings = new ArrayList<ValidationFailure>();
    private ClassLoader classLoader;
    private URL sourceBase;
    private String targetNamespace;
    private URI contributionUri;
    private Map<Class<?>, TypeMapping> typeMappings = new HashMap();

    public DefaultIntrospectionContext() {
    }

    public DefaultIntrospectionContext(URI contributionUri, ClassLoader classLoader, URL sourceBase, String targetNamespace) {
        this.classLoader = classLoader;
        this.sourceBase = sourceBase;
        this.targetNamespace = targetNamespace;
        this.contributionUri = contributionUri;
    }

    public DefaultIntrospectionContext(URI contributionUri, ClassLoader classLoader) {
        this(contributionUri, classLoader, null, null);
    }

    public DefaultIntrospectionContext(URI contributionUri, ClassLoader classLoader, URL sourceBase) {
        this(contributionUri, classLoader, sourceBase, null);
    }

    public DefaultIntrospectionContext(IntrospectionContext parentContext, String targetNamespace) {
        this(parentContext.getContributionUri(), parentContext.getClassLoader(), parentContext.getSourceBase(), targetNamespace);
    }

    public DefaultIntrospectionContext(IntrospectionContext parentContext) {
        this(parentContext.getContributionUri(), parentContext.getClassLoader(), parentContext.getSourceBase(), parentContext.getTargetNamespace());
        this.typeMappings.putAll(parentContext.getTypeMappings());
    }

    @Override
    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    @Override
    public List<ValidationFailure> getErrors() {
        return this.errors;
    }

    @Override
    public void addError(ValidationFailure e) {
        this.errors.add(e);
    }

    @Override
    public void addErrors(List<ValidationFailure> errors) {
        this.errors.addAll(errors);
    }

    @Override
    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    @Override
    public List<ValidationFailure> getWarnings() {
        return this.warnings;
    }

    @Override
    public void addWarning(ValidationFailure e) {
        this.warnings.add(e);
    }

    @Override
    public void addWarnings(List<ValidationFailure> warnings) {
        this.warnings.addAll(warnings);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.classLoader;
    }

    @Override
    public URL getSourceBase() {
        return this.sourceBase;
    }

    @Override
    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    @Override
    public void setTargetNamespace(String targetNamespace) {
        this.targetNamespace = targetNamespace;
    }

    @Override
    public URI getContributionUri() {
        return this.contributionUri;
    }

    @Override
    public TypeMapping getTypeMapping(Class<?> type) {
        return this.typeMappings.get(type);
    }

    @Override
    public void addTypeMapping(Class<?> type, TypeMapping typeMapping) {
        this.typeMappings.put(type, typeMapping);
    }

    @Override
    public Map<Class<?>, TypeMapping> getTypeMappings() {
        return this.typeMappings;
    }
}

