/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.xml;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.spi.introspection.IntrospectionException;

public class LoaderException
extends IntrospectionException {
    public static final int UNDEFINED = -1;
    private static final long serialVersionUID = -7459051598906813461L;
    private final String resourceURI;
    private final int line;
    private final int column;

    public LoaderException(String message, XMLStreamReader reader) {
        super(message);
        Location location = reader.getLocation();
        if (location != null) {
            this.line = location.getLineNumber();
            this.column = location.getColumnNumber();
            this.resourceURI = location.getSystemId();
        } else {
            this.resourceURI = "system";
            this.line = -1;
            this.column = -1;
        }
    }

    public LoaderException(String message, Throwable cause) {
        super(message, cause);
        this.line = -1;
        this.column = -1;
        this.resourceURI = null;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(((Object)((Object)this)).getClass().getName());
        builder.append(" in ");
        builder.append(this.resourceURI == null ? "unknown" : this.resourceURI);
        if (this.line != -1) {
            builder.append(" at ").append(this.line).append(',').append(this.column);
        }
        builder.append(": ");
        builder.append(this.getLocalizedMessage());
        return builder.toString();
    }
}

