/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.spi.introspection.xml.DeprecatedNamespaceHelper;
import org.fabric3.spi.introspection.xml.LoaderException;

public class UnrecognizedElementException
extends LoaderException {
    private static final long serialVersionUID = 2549543622209829032L;
    private final QName element;

    public UnrecognizedElementException(XMLStreamReader reader) {
        super("Unrecognized element", reader);
        this.element = reader.getName();
    }

    public QName getElement() {
        return this.element;
    }

    public String getMessage() {
        String namespace = this.element.getNamespaceURI();
        if (DeprecatedNamespaceHelper.isDeprecatedNamespace(namespace)) {
            return "The element " + this.getElement() + " uses the deprecated namespace " + namespace + ". Please change it to " + "urn:fabric3.org";
        }
        return "The element " + this.getElement() + " was not recognized. If this is not a typo, check to ensure extensions are configured properly.";
    }
}

