/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.introspection.xml;

import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;

public abstract class XmlValidationFailure
extends ValidationFailure {
    private final int line;
    private final int column;
    private final String message;
    private String resourceURI;
    private int offset;

    protected XmlValidationFailure(String message, XMLStreamReader reader) {
        this.message = message;
        Location location = reader.getLocation();
        if (location != null) {
            this.line = location.getLineNumber();
            this.column = location.getColumnNumber();
            this.offset = location.getCharacterOffset();
            this.resourceURI = location.getSystemId();
        } else {
            this.resourceURI = "system";
            this.line = -1;
            this.column = -1;
        }
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getResourceURI() {
        return this.resourceURI;
    }

    public String getMessage() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.message);
        if (this.line != -1) {
            builder.append(" [").append(this.line).append(',').append(this.column).append("]");
        }
        return builder.toString();
    }
}

