/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.CompositeImplementation;
import org.fabric3.spi.model.instance.Bindable;
import org.fabric3.spi.model.instance.LogicalBinding;
import org.fabric3.spi.model.instance.LogicalChannel;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalCompositeComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalInvocable;
import org.fabric3.spi.model.instance.LogicalOperation;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalProperty;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResource;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.instance.LogicalWire;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyUtil {
    private CopyUtil() {
    }

    public static LogicalCompositeComponent copy(LogicalCompositeComponent composite) {
        return CopyUtil.copy(composite, (LogicalCompositeComponent)composite.getParent());
    }

    private static LogicalCompositeComponent copy(LogicalCompositeComponent composite, LogicalCompositeComponent parent) {
        HashMap components = new HashMap();
        HashMap<URI, LogicalReference> references = new HashMap<URI, LogicalReference>();
        HashMap<URI, LogicalService> services = new HashMap<URI, LogicalService>();
        LogicalCompositeComponent replica = CopyUtil.copy(composite, parent, components, services, references);
        CopyUtil.copyWires(composite, components, services);
        return replica;
    }

    private static LogicalCompositeComponent copy(LogicalCompositeComponent composite, LogicalCompositeComponent parent, Map<URI, LogicalComponent<?>> components, Map<URI, LogicalService> services, Map<URI, LogicalReference> references) {
        URI uri = composite.getUri();
        ComponentDefinition definition = composite.getDefinition();
        LogicalCompositeComponent copy = new LogicalCompositeComponent(uri, (ComponentDefinition<CompositeImplementation>)definition, parent);
        components.put(uri, copy);
        copy.setAutowire(composite.getAutowire());
        copy.setState(composite.getState());
        copy.setZone(composite.getZone());
        copy.setDeployable(composite.getDeployable());
        copy.addIntents(composite.getIntents());
        copy.addPolicySets(composite.getPolicySets());
        for (LogicalProperty logicalProperty : composite.getAllProperties().values()) {
            copy.setProperties(logicalProperty);
        }
        for (LogicalComponent logicalComponent : composite.getComponents()) {
            CopyUtil.copy(logicalComponent, copy, components, services, references);
        }
        for (LogicalReference logicalReference : composite.getReferences()) {
            CopyUtil.copy(logicalReference, copy, references);
        }
        for (LogicalResourceReference logicalResourceReference : composite.getResourceReferences()) {
            CopyUtil.copy(logicalResourceReference, (LogicalComponent)copy);
        }
        for (LogicalService logicalService : composite.getServices()) {
            CopyUtil.copy(logicalService, copy, components, services);
        }
        for (LogicalChannel logicalChannel : composite.getChannels()) {
            CopyUtil.copy(logicalChannel, copy);
        }
        for (LogicalConsumer logicalConsumer : composite.getConsumers()) {
            CopyUtil.copy(logicalConsumer, (LogicalComponent)copy);
        }
        for (LogicalProducer logicalProducer : composite.getProducers()) {
            CopyUtil.copy(logicalProducer, (LogicalComponent)copy);
        }
        for (LogicalResource logicalResource : composite.getResources()) {
            CopyUtil.copy(logicalResource, copy);
        }
        return copy;
    }

    private static void copy(LogicalComponent<?> component, LogicalCompositeComponent newParent, Map<URI, LogicalComponent<?>> components, Map<URI, LogicalService> services, Map<URI, LogicalReference> references) {
        LogicalComponent copy;
        if (component instanceof LogicalCompositeComponent) {
            copy = CopyUtil.copy((LogicalCompositeComponent)component, newParent, components, services, references);
        } else {
            URI uri = component.getUri();
            copy = new LogicalComponent(uri, component.getDefinition(), newParent);
            copy.setAutowire(component.getAutowire());
            copy.setState(component.getState());
            copy.setZone(component.getZone());
            copy.setDeployable(component.getDeployable());
            copy.addIntents(component.getIntents());
            copy.addPolicySets(component.getPolicySets());
            components.put(uri, copy);
            for (LogicalProperty logicalProperty : component.getAllProperties().values()) {
                copy.setProperties(logicalProperty);
            }
            for (LogicalReference logicalReference : component.getReferences()) {
                CopyUtil.copy(logicalReference, copy, references);
            }
            for (LogicalResourceReference logicalResourceReference : component.getResourceReferences()) {
                CopyUtil.copy(logicalResourceReference, copy);
            }
            for (LogicalService logicalService : component.getServices()) {
                CopyUtil.copy(logicalService, copy, components, services);
            }
            for (LogicalConsumer logicalConsumer : component.getConsumers()) {
                CopyUtil.copy(logicalConsumer, copy);
            }
            for (LogicalProducer logicalProducer : component.getProducers()) {
                CopyUtil.copy(logicalProducer, copy);
            }
        }
        newParent.addComponent(copy);
    }

    private static void copy(LogicalReference reference, LogicalComponent parent, Map<URI, LogicalReference> references) {
        URI referenceUri = reference.getUri();
        LogicalReference copy = new LogicalReference(referenceUri, reference.getDefinition(), parent);
        references.put(referenceUri, copy);
        for (URI uri : reference.getPromotedUris()) {
            copy.addPromotedUri(uri);
        }
        copy.setAutowire(reference.getAutowire());
        copy.setLeafReference(references.get(reference.getLeafReference().getUri()));
        copy.setResolved(reference.isResolved());
        copy.setServiceContract(reference.getServiceContract());
        for (URI uri : reference.getPromotedUris()) {
            copy.addPromotedUri(uri);
        }
        copy.addIntents(reference.getIntents());
        copy.addPolicySets(reference.getPolicySets());
        CopyUtil.copy(reference, copy);
        parent.addReference(copy);
    }

    private static void copy(LogicalResourceReference<?> resourceReference, LogicalComponent parent) {
        URI uri = resourceReference.getUri();
        Object definition = resourceReference.getDefinition();
        LogicalResourceReference copy = new LogicalResourceReference(uri, definition, parent);
        copy.setTarget(resourceReference.getTarget());
        parent.addResource(copy);
    }

    private static void copy(LogicalService service, LogicalComponent parent, Map<URI, LogicalComponent<?>> components, Map<URI, LogicalService> services) {
        URI uri = service.getUri();
        LogicalService copy = new LogicalService(uri, service.getDefinition(), parent);
        services.put(uri, copy);
        copy.setLeafComponent(components.get(service.getLeafComponent().getUri()));
        copy.setLeafService(services.get(service.getLeafService().getUri()));
        copy.setServiceContract(service.getServiceContract());
        copy.setPromotedUri(service.getPromotedUri());
        copy.addIntents(service.getIntents());
        copy.addPolicySets(service.getPolicySets());
        CopyUtil.copy(service, copy);
        parent.addService(copy);
    }

    private static void copy(LogicalChannel channel, LogicalCompositeComponent parent) {
        URI uri = channel.getUri();
        LogicalChannel copy = new LogicalChannel(uri, channel.getDefinition(), parent);
        copy.setServiceContract(channel.getServiceContract());
        CopyUtil.copy((Bindable)channel, copy);
        copy.setDeployable(channel.getDeployable());
        copy.addIntents(channel.getIntents());
        copy.addPolicySets(channel.getPolicySets());
        copy.setState(channel.getState());
        copy.setZone(channel.getZone());
        parent.addChannel(copy);
    }

    private static void copy(LogicalProducer producer, LogicalComponent parent) {
        URI uri = producer.getUri();
        LogicalProducer copy = new LogicalProducer(uri, producer.getDefinition(), parent);
        copy.setServiceContract(producer.getServiceContract());
        copy.addTargets(producer.getTargets());
        CopyUtil.copyInvocable(producer, copy);
        copy.addIntents(producer.getIntents());
        copy.addPolicySets(producer.getPolicySets());
        parent.addProducer(copy);
    }

    private static void copy(LogicalConsumer consumer, LogicalComponent parent) {
        URI uri = consumer.getUri();
        LogicalConsumer copy = new LogicalConsumer(uri, consumer.getDefinition(), parent);
        copy.setServiceContract(consumer.getServiceContract());
        copy.addSources(consumer.getSources());
        CopyUtil.copyInvocable(consumer, copy);
        copy.addIntents(consumer.getIntents());
        copy.addPolicySets(consumer.getPolicySets());
        parent.addConsumer(copy);
    }

    private static void copy(LogicalResource resource, LogicalCompositeComponent parent) {
        LogicalResource copy = new LogicalResource(resource.getDefinition(), parent);
        copy.setDeployable(resource.getDeployable());
        copy.setState(resource.getState());
        copy.setZone(resource.getZone());
        parent.addResource(copy);
    }

    private static void copy(Bindable from, Bindable to) {
        LogicalBinding copy;
        for (LogicalBinding<?> binding : from.getBindings()) {
            copy = new LogicalBinding(binding.getDefinition(), to, binding.getDeployable());
            copy.setState(binding.getState());
            to.addBinding(copy);
            copy.setAssigned(binding.isAssigned());
            copy.addIntents(binding.getIntents());
            copy.addPolicySets(binding.getPolicySets());
        }
        for (LogicalBinding<?> binding : from.getCallbackBindings()) {
            copy = new LogicalBinding(binding.getDefinition(), to, binding.getDeployable());
            copy.setState(binding.getState());
            to.addCallbackBinding(copy);
            copy.setAssigned(binding.isAssigned());
            copy.addIntents(binding.getIntents());
            copy.addPolicySets(binding.getPolicySets());
        }
        CopyUtil.copyInvocable(from, to);
    }

    private static void copyInvocable(LogicalInvocable from, LogicalInvocable to) {
        ArrayList<LogicalOperation> operations = new ArrayList<LogicalOperation>();
        for (LogicalOperation operation : from.getOperations()) {
            LogicalOperation copy = new LogicalOperation(operation.getDefinition(), to);
            copy.addIntents(operation.getIntents());
            copy.addPolicySets(operation.getPolicySets());
            operations.add(copy);
        }
        to.overrideOperations(operations);
    }

    private static void copyWires(LogicalComponent<?> fromComponent, Map<URI, LogicalComponent<?>> components, Map<URI, LogicalService> services) {
        LogicalComponent<?> toComponent = components.get(fromComponent.getUri());
        if (fromComponent instanceof LogicalCompositeComponent) {
            LogicalCompositeComponent composite = (LogicalCompositeComponent)fromComponent;
            for (LogicalComponent<?> component : composite.getComponents()) {
                CopyUtil.copyWires(component, components, services);
            }
        }
        for (LogicalReference fromReference : fromComponent.getReferences()) {
            LogicalReference toReference = toComponent.getReference(fromReference.getUri().getFragment());
            LogicalCompositeComponent originalParent = (LogicalCompositeComponent)fromComponent.getParent();
            LogicalCompositeComponent newParent = (LogicalCompositeComponent)toComponent.getParent();
            CopyUtil.copyWires(fromReference, toReference, originalParent, newParent, services);
        }
    }

    private static void copyWires(LogicalReference fromReference, LogicalReference toReference, LogicalCompositeComponent from, LogicalCompositeComponent to, Map<URI, LogicalService> services) {
        for (LogicalWire wire : from.getWires(fromReference)) {
            QName deployable = wire.getTargetDeployable();
            boolean replaceable = wire.isReplaceable();
            LogicalService fromTarget = wire.getTarget();
            LogicalService toTarget = services.get(fromTarget.getUri());
            LogicalWire wireCopy = new LogicalWire(to, toReference, toTarget, deployable, replaceable);
            wireCopy.setState(wire.getState());
            wireCopy.setReplaces(wire.isReplaces());
            LogicalBinding fromSourceBinding = wire.getSourceBinding();
            LogicalBinding<?> toSourceBinding = null;
            if (fromSourceBinding != null) {
                for (LogicalBinding<?> binding : toReference.getBindings()) {
                    if (!fromSourceBinding.getDefinition().getName().equals(binding.getDefinition().getName())) continue;
                    toSourceBinding = binding;
                    break;
                }
            }
            wireCopy.setSourceBinding(toSourceBinding);
            LogicalBinding fromTargetBinding = wire.getTargetBinding();
            LogicalBinding<?> toTargetBinding = null;
            if (fromTargetBinding != null) {
                if (!toTarget.getBindings().isEmpty()) {
                    for (LogicalBinding<?> binding : toTarget.getBindings()) {
                        if (!fromTargetBinding.getDefinition().getName().equals(binding.getDefinition().getName())) continue;
                        toTargetBinding = binding;
                        break;
                    }
                } else {
                    for (LogicalBinding<?> binding : toTarget.getLeafService().getBindings()) {
                        if (!fromTargetBinding.getDefinition().getName().equals(binding.getDefinition().getName())) continue;
                        toTargetBinding = binding;
                        break;
                    }
                }
            }
            wireCopy.setTargetBinding(toTargetBinding);
            to.addWire(toReference, wireCopy);
        }
    }
}

