/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.instance;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.model.instance.LogicalAttachPoint;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogicalInvocable
extends LogicalAttachPoint {
    private static final long serialVersionUID = 4182922230894994435L;
    protected ServiceContract serviceContract;
    protected List<LogicalOperation> operations;
    protected List<LogicalOperation> callbackOperations;

    protected LogicalInvocable(URI uri, ServiceContract contract, LogicalComponent<?> parent) {
        super(uri, parent);
        this.createOperations(contract);
        this.serviceContract = contract;
    }

    public List<LogicalOperation> getOperations() {
        return this.operations;
    }

    public List<LogicalOperation> getCallbackOperations() {
        return this.callbackOperations;
    }

    public ServiceContract getServiceContract() {
        return this.serviceContract;
    }

    public void setServiceContract(ServiceContract serviceContract) {
        this.serviceContract = serviceContract;
        this.createOperations(serviceContract);
    }

    void overrideOperations(List<LogicalOperation> operations) {
        this.operations = operations;
    }

    protected final void createOperations(ServiceContract contract) {
        this.operations = new ArrayList<LogicalOperation>();
        this.callbackOperations = new ArrayList<LogicalOperation>();
        if (contract != null) {
            for (Operation operation : contract.getOperations()) {
                this.operations.add(new LogicalOperation(operation, this));
            }
            ServiceContract callbackContract = contract.getCallbackContract();
            if (callbackContract != null) {
                for (Operation operation : callbackContract.getOperations()) {
                    this.callbackOperations.add(new LogicalOperation(operation, this));
                }
            }
        }
    }
}

