/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.type.java;

import java.util.HashMap;
import java.util.Map;
import org.fabric3.model.type.component.CallbackDefinition;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.model.type.component.ConsumerDefinition;
import org.fabric3.model.type.component.ProducerDefinition;
import org.fabric3.model.type.component.Property;
import org.fabric3.model.type.component.ReferenceDefinition;
import org.fabric3.model.type.component.ResourceReferenceDefinition;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.model.type.java.InjectionSite;
import org.fabric3.spi.model.type.java.ManagementInfo;
import org.fabric3.spi.model.type.java.Signature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectingComponentType
extends ComponentType {
    private static final long serialVersionUID = -2602867276842414240L;
    private String implClass;
    private String scope;
    private int initLevel;
    private boolean managed;
    private ManagementInfo managementInfo;
    private Signature constructor;
    private Signature initMethod;
    private Signature destroyMethod;
    private Map<InjectionSite, Injectable> injectionSites = new HashMap<InjectionSite, Injectable>();
    private Map<String, CallbackDefinition> callbacks = new HashMap<String, CallbackDefinition>();
    private Map<String, Signature> consumerSignatures = new HashMap<String, Signature>();

    public InjectingComponentType(String implClass) {
        this.implClass = implClass;
    }

    public InjectingComponentType() {
    }

    public String getImplClass() {
        return this.implClass;
    }

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    public void setInitLevel(int initLevel) {
        this.initLevel = initLevel;
    }

    public boolean isEagerInit() {
        return this.initLevel > 0;
    }

    public boolean isManaged() {
        return this.managed;
    }

    public void setManaged(boolean managed) {
        this.managed = managed;
    }

    public ManagementInfo getManagementInfo() {
        return this.managementInfo;
    }

    public void setManagementInfo(ManagementInfo managementInfo) {
        this.managementInfo = managementInfo;
    }

    public void add(ReferenceDefinition reference, InjectionSite injectionSite) {
        super.add(reference);
        Injectable injectable = new Injectable(InjectableType.REFERENCE, reference.getName());
        this.addInjectionSite(injectionSite, injectable);
    }

    public void add(ProducerDefinition producer, InjectionSite injectionSite) {
        super.add(producer);
        Injectable injectable = new Injectable(InjectableType.PRODUCER, producer.getName());
        this.addInjectionSite(injectionSite, injectable);
    }

    public void add(ConsumerDefinition consumer, Signature signature) {
        super.add(consumer);
        this.consumerSignatures.put(consumer.getName(), signature);
    }

    public Signature getConsumerSignature(String name) {
        return this.consumerSignatures.get(name);
    }

    public void add(Property property, InjectionSite injectionSite) {
        super.add(property);
        Injectable injectable = new Injectable(InjectableType.PROPERTY, property.getName());
        this.addInjectionSite(injectionSite, injectable);
    }

    public void add(ResourceReferenceDefinition definition, InjectionSite injectionSite) {
        super.add(definition);
        Injectable injectable = new Injectable(InjectableType.RESOURCE, definition.getName());
        this.addInjectionSite(injectionSite, injectable);
    }

    public void add(CallbackDefinition definition, InjectionSite injectionSite) {
        String name = definition.getName();
        this.callbacks.put(name, definition);
        Injectable injectable = new Injectable(InjectableType.CALLBACK, name);
        this.addInjectionSite(injectionSite, injectable);
    }

    public Map<String, CallbackDefinition> getCallbacks() {
        return this.callbacks;
    }

    public void addInjectionSite(InjectionSite site, Injectable source) {
        this.injectionSites.put(site, source);
    }

    public Map<InjectionSite, Injectable> getInjectionSites() {
        return this.injectionSites;
    }

    public Signature getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Signature constructor) {
        this.constructor = constructor;
    }

    public Signature getInitMethod() {
        return this.initMethod;
    }

    public void setInitMethod(Signature initMethod) {
        this.initMethod = initMethod;
    }

    public Signature getDestroyMethod() {
        return this.destroyMethod;
    }

    public void setDestroyMethod(Signature destroyMethod) {
        this.destroyMethod = destroyMethod;
    }
}

