/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.type.java;

import java.util.Collections;
import java.util.List;
import org.fabric3.model.type.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTypeInfo
extends ModelObject {
    private static final long serialVersionUID = -9157948376540103018L;
    private Class<?> rawType;
    private List<JavaTypeInfo> parameterTypeInfos;

    public JavaTypeInfo(Class<?> rawType) {
        this.rawType = rawType;
    }

    public JavaTypeInfo(Class<?> rawType, List<JavaTypeInfo> parameterTypeInfos) {
        this.rawType = rawType;
        this.parameterTypeInfos = parameterTypeInfos;
    }

    public Class<?> getRawType() {
        return this.rawType;
    }

    public List<JavaTypeInfo> getParameterTypesInfos() {
        if (this.parameterTypeInfos == null) {
            return Collections.emptyList();
        }
        return this.parameterTypeInfos;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        JavaTypeInfo that = (JavaTypeInfo)((Object)o);
        if (this.parameterTypeInfos == null && that.parameterTypeInfos != null) {
            boolean allObject = true;
            for (JavaTypeInfo info : that.parameterTypeInfos) {
                if (Object.class.equals(info.getRawType())) continue;
                allObject = false;
                break;
            }
            if (allObject && this.rawType.equals(that.rawType)) {
                return true;
            }
        } else if (this.parameterTypeInfos != null && that.parameterTypeInfos == null) {
            boolean allObject = true;
            for (JavaTypeInfo info : this.parameterTypeInfos) {
                if (Object.class.equals(info.getRawType())) continue;
                allObject = false;
                break;
            }
            if (allObject && this.rawType.equals(that.rawType)) {
                return true;
            }
        }
        return !(this.parameterTypeInfos == null ? that.parameterTypeInfos != null : !((Object)this.parameterTypeInfos).equals(that.parameterTypeInfos)) && this.rawType.equals(that.rawType);
    }

    public int hashCode() {
        return this.rawType.hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.write(this, builder);
        return builder.toString();
    }

    private void write(JavaTypeInfo typeInfo, StringBuilder builder) {
        Class<?> rawType = typeInfo.getRawType();
        builder.append(rawType.getName());
        List<JavaTypeInfo> infos = typeInfo.getParameterTypesInfos();
        if (!infos.isEmpty()) {
            builder.append("<");
            for (int i = 0; i < infos.size(); ++i) {
                JavaTypeInfo info = infos.get(i);
                if (i != 0) {
                    builder.append(", ");
                }
                builder.append((Object)info);
            }
            builder.append(">");
        }
    }
}

