/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.spi.model.type.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.fabric3.model.type.ModelObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Signature
extends ModelObject {
    private static final long serialVersionUID = 4851321624672183132L;
    private static final Map<String, Class<?>> PRIMITIVES_TYPES = new HashMap();
    private String name;
    private List<String> parameterTypes;
    private boolean isConstructor = false;

    public Signature() {
    }

    public Signature(String name, String ... types) {
        this.name = name;
        this.parameterTypes = Arrays.asList(types);
    }

    public Signature(String name, List<String> types) {
        this.name = name;
        this.parameterTypes = types;
    }

    public Signature(Method method) {
        this.name = method.getName();
        this.setParameterTypes(method.getParameterTypes());
    }

    public Signature(Constructor constructor) {
        this.name = "init";
        this.setParameterTypes(constructor.getParameterTypes());
        this.isConstructor = true;
    }

    public Method getMethod(Class<?> clazz) throws ClassNotFoundException, NoSuchMethodException {
        if (this.isConstructor) {
            throw new AssertionError((Object)"Illegal call to getMethod on a Constructor Signature");
        }
        Class<?>[] types = this.getParameterTypes(clazz.getClassLoader());
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(this.name, types);
            }
            catch (NoSuchMethodException e) {
                clazz = clazz.getSuperclass();
            }
        }
        throw new NoSuchMethodException(this.toString());
    }

    public <T> Constructor<T> getConstructor(Class<T> clazz) throws ClassNotFoundException, NoSuchMethodException {
        if (!this.isConstructor) {
            throw new AssertionError((Object)"Illegal call to getConstructor on a Method Signature");
        }
        Class<?>[] types = this.getParameterTypes(clazz.getClassLoader());
        return clazz.getConstructor(types);
    }

    private void setParameterTypes(Class<?>[] classes) {
        this.parameterTypes = new ArrayList<String>(classes.length);
        for (Class<?> paramType : classes) {
            this.parameterTypes.add(paramType.getName());
        }
    }

    private Class<?>[] getParameterTypes(ClassLoader cl) throws ClassNotFoundException {
        Class[] types = new Class[this.parameterTypes.size()];
        for (int i = 0; i < types.length; ++i) {
            String type = this.parameterTypes.get(i);
            Class<?> clazz = PRIMITIVES_TYPES.get(type);
            types[i] = clazz != null ? clazz : Class.forName(type, true, cl);
        }
        return types;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getParameterTypes() {
        return this.parameterTypes;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name);
        builder.append('(');
        if (this.parameterTypes.size() > 0) {
            builder.append(this.parameterTypes.get(0));
        }
        for (int i = 1; i < this.parameterTypes.size(); ++i) {
            builder.append(", ").append(this.parameterTypes.get(i));
        }
        builder.append(')');
        return builder.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Signature signature = (Signature)((Object)o);
        return this.name.equals(signature.name) && ((Object)this.parameterTypes).equals(signature.parameterTypes);
    }

    public int hashCode() {
        return this.name.hashCode() + 31 * ((Object)this.parameterTypes).hashCode();
    }

    static {
        PRIMITIVES_TYPES.put("boolean", Boolean.TYPE);
        PRIMITIVES_TYPES.put("char", Character.class);
        PRIMITIVES_TYPES.put("byte", Byte.TYPE);
        PRIMITIVES_TYPES.put("short", Short.TYPE);
        PRIMITIVES_TYPES.put("int", Integer.TYPE);
        PRIMITIVES_TYPES.put("long", Long.TYPE);
        PRIMITIVES_TYPES.put("float", Float.TYPE);
        PRIMITIVES_TYPES.put("double", Double.TYPE);
    }
}

