/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.java2java;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.fabric3.spi.classloader.ClassLoaderObjectInputStream;
import org.fabric3.spi.transform.TransformationException;
import org.fabric3.spi.transform.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Java2JavaTransformer
implements Transformer<Serializable, Serializable> {
    public Serializable transform(Serializable source, ClassLoader loader) throws TransformationException {
        byte[] bytes = this.serialize(source);
        return this.deserialize(bytes, loader);
    }

    private byte[] serialize(Object o) throws TransformationException {
        if (o == null) {
            throw new TransformationException("Attempt to serialize a null object");
        }
        if (!(o instanceof Serializable)) {
            throw new TransformationException("Parameters for Java-to-Java transformations must implement Serializable: " + o.getClass());
        }
        ObjectOutputStream stream = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            stream = new ObjectOutputStream(bos);
            stream.writeObject(o);
            stream.flush();
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private Serializable deserialize(byte[] bytes, ClassLoader loader) throws TransformationException {
        ByteArrayInputStream bis = null;
        ObjectInputStream stream = null;
        try {
            bis = new ByteArrayInputStream(bytes);
            stream = new ClassLoaderObjectInputStream((InputStream)bis, loader);
            Serializable serializable = (Serializable)stream.readObject();
            return serializable;
        }
        catch (IOException e) {
            throw new TransformationException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new TransformationException((Throwable)e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

