/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.oasisopen.sca.annotation.Reference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property2ClassTransformer
implements SingleTypeTransformer<Node, Class<?>> {
    private static final JavaClass<Class> TARGET = new JavaClass(Class.class);
    private final ClassLoaderRegistry classLoaderRegistry;

    public DataType<?> getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public Property2ClassTransformer(@Reference ClassLoaderRegistry classLoaderRegistry) {
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public DataType<?> getTargetType() {
        return TARGET;
    }

    public Class<?> transform(Node node, ClassLoader loader) throws TransformationException {
        try {
            return this.classLoaderRegistry.loadClass(loader, node.getTextContent());
        }
        catch (ClassNotFoundException e) {
            throw new TransformationException((Throwable)e);
        }
    }
}

