/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.net.URI;
import java.net.URISyntaxException;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property2URITransformer
implements SingleTypeTransformer<Node, URI> {
    private static final JavaClass<URI> TARGET = new JavaClass(URI.class);

    public DataType<?> getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType<?> getTargetType() {
        return TARGET;
    }

    public URI transform(Node node, ClassLoader loader) throws TransformationException {
        URI uri;
        String content = node.getTextContent();
        try {
            uri = new URI(node.getTextContent());
        }
        catch (URISyntaxException ue) {
            throw new TransformationException("Unable to create URI :- " + content, (Throwable)ue);
        }
        return uri;
    }
}

