/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.transform.property;

import java.net.MalformedURLException;
import java.net.URL;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.spi.model.type.java.JavaClass;
import org.fabric3.spi.model.type.xsd.XSDConstants;
import org.fabric3.spi.transform.SingleTypeTransformer;
import org.fabric3.spi.transform.TransformationException;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property2URLTransformer
implements SingleTypeTransformer<Node, URL> {
    private static final JavaClass<URL> TARGET = new JavaClass(URL.class);

    public DataType<?> getSourceType() {
        return XSDConstants.PROPERTY_TYPE;
    }

    public DataType<?> getTargetType() {
        return TARGET;
    }

    public URL transform(Node node, ClassLoader loader) throws TransformationException {
        URL url;
        String content = node.getTextContent();
        try {
            url = new URL(node.getTextContent());
        }
        catch (MalformedURLException me) {
            throw new TransformationException("Unable to create URL :- " + content, (Throwable)me);
        }
        return url;
    }
}

