/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.generator;

import java.net.URI;
import org.fabric3.implementation.java.generator.CallbackSiteNotFoundException;
import org.fabric3.implementation.java.generator.JavaGenerationHelper;
import org.fabric3.implementation.java.model.JavaImplementation;
import org.fabric3.implementation.java.provision.JavaComponentDefinition;
import org.fabric3.implementation.java.provision.JavaConnectionSourceDefinition;
import org.fabric3.implementation.java.provision.JavaConnectionTargetDefinition;
import org.fabric3.implementation.java.provision.JavaSourceDefinition;
import org.fabric3.implementation.java.provision.JavaTargetDefinition;
import org.fabric3.implementation.pojo.generator.GenerationHelper;
import org.fabric3.implementation.pojo.provision.ImplementationManagerDefinition;
import org.fabric3.implementation.pojo.provision.PojoComponentDefinition;
import org.fabric3.model.type.component.CallbackDefinition;
import org.fabric3.model.type.component.ComponentDefinition;
import org.fabric3.model.type.component.Scope;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.ServiceContract;
import org.fabric3.spi.contract.ContractMatcher;
import org.fabric3.spi.contract.MatchResult;
import org.fabric3.spi.generator.EffectivePolicy;
import org.fabric3.spi.generator.GenerationException;
import org.fabric3.spi.model.instance.LogicalComponent;
import org.fabric3.spi.model.instance.LogicalConsumer;
import org.fabric3.spi.model.instance.LogicalProducer;
import org.fabric3.spi.model.instance.LogicalReference;
import org.fabric3.spi.model.instance.LogicalResourceReference;
import org.fabric3.spi.model.instance.LogicalService;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.fabric3.spi.model.type.java.Signature;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaGenerationHelperImpl
implements JavaGenerationHelper {
    private final GenerationHelper helper;
    private ContractMatcher matcher;

    public JavaGenerationHelperImpl(@Reference GenerationHelper helper, @Reference ContractMatcher matcher) {
        this.helper = helper;
        this.matcher = matcher;
    }

    @Override
    public void generate(JavaComponentDefinition definition, LogicalComponent<? extends JavaImplementation> component) throws GenerationException {
        ComponentDefinition logical = component.getDefinition();
        JavaImplementation implementation = (JavaImplementation)logical.getImplementation();
        InjectingComponentType type = (InjectingComponentType)implementation.getComponentType();
        String scope = type.getScope();
        ImplementationManagerDefinition managerDefinition = new ImplementationManagerDefinition();
        managerDefinition.setComponentUri(component.getUri());
        managerDefinition.setReinjectable(Scope.COMPOSITE.getScope().equals(scope));
        managerDefinition.setConstructor(type.getConstructor());
        managerDefinition.setInitMethod(type.getInitMethod());
        managerDefinition.setDestroyMethod(type.getDestroyMethod());
        managerDefinition.setImplementationClass(implementation.getImplementationClass());
        this.helper.processInjectionSites(type, managerDefinition);
        definition.setScope(scope);
        definition.setEagerInit(type.isEagerInit());
        definition.setManagerDefinition(managerDefinition);
        definition.setManaged(type.isManaged());
        definition.setManagementInfo(type.getManagementInfo());
        this.helper.processPropertyValues(component, (PojoComponentDefinition)definition);
    }

    @Override
    public void generateWireSource(JavaSourceDefinition definition, LogicalReference reference, EffectivePolicy policy) throws GenerationException {
        URI uri = reference.getUri();
        ServiceContract serviceContract = reference.getDefinition().getServiceContract();
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        definition.setUri(uri);
        definition.setInjectable(new Injectable(InjectableType.REFERENCE, uri.getFragment()));
        definition.setInterfaceName(interfaceName);
        definition.setOptimizable(true);
        if (reference.getDefinition().isKeyed()) {
            definition.setKeyed(true);
            DataType type = reference.getDefinition().getKeyDataType();
            String className = type.getPhysical().getName();
            definition.setKeyClassName(className);
        }
    }

    @Override
    public void generateConnectionSource(JavaConnectionSourceDefinition definition, LogicalProducer producer) throws GenerationException {
        URI uri = producer.getUri();
        ServiceContract serviceContract = producer.getDefinition().getServiceContract();
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        definition.setUri(uri);
        definition.setInjectable(new Injectable(InjectableType.PRODUCER, uri.getFragment()));
        definition.setInterfaceName(interfaceName);
    }

    @Override
    public void generateConnectionTarget(JavaConnectionTargetDefinition definition, LogicalConsumer consumer) throws GenerationException {
        LogicalComponent component = (LogicalComponent)consumer.getParent();
        URI uri = component.getUri();
        definition.setTargetUri(uri);
        InjectingComponentType type = (InjectingComponentType)((JavaImplementation)component.getDefinition().getImplementation()).getComponentType();
        Signature signature = type.getConsumerSignature(consumer.getUri().getFragment());
        if (signature == null) {
            throw new GenerationException("Consumer signature not found on: " + consumer.getUri());
        }
        definition.setConsumerSignature(signature);
    }

    @Override
    public void generateCallbackWireSource(JavaSourceDefinition definition, LogicalComponent<? extends JavaImplementation> component, ServiceContract serviceContract, EffectivePolicy policy) throws GenerationException {
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        InjectingComponentType type = (InjectingComponentType)((JavaImplementation)component.getDefinition().getImplementation()).getComponentType();
        String name = null;
        for (CallbackDefinition entry : type.getCallbacks().values()) {
            ServiceContract candidate = entry.getServiceContract();
            MatchResult result = this.matcher.isAssignableFrom(candidate, serviceContract, false);
            if (!result.isAssignable()) continue;
            name = entry.getName();
            break;
        }
        if (name == null) {
            String interfaze = serviceContract.getQualifiedInterfaceName();
            throw new CallbackSiteNotFoundException("Callback injection site not found for type: " + interfaze, interfaze);
        }
        Injectable injectable = new Injectable(InjectableType.CALLBACK, name);
        definition.setInjectable(injectable);
        definition.setInterfaceName(interfaceName);
        URI uri = URI.create(component.getUri().toString() + "#" + name);
        definition.setUri(uri);
        definition.setOptimizable(false);
    }

    @Override
    public void generateResourceWireSource(JavaSourceDefinition wireDefinition, LogicalResourceReference<?> resourceReference) throws GenerationException {
        URI uri = resourceReference.getUri();
        ServiceContract serviceContract = resourceReference.getDefinition().getServiceContract();
        String interfaceName = serviceContract.getQualifiedInterfaceName();
        wireDefinition.setUri(uri);
        wireDefinition.setInjectable(new Injectable(InjectableType.RESOURCE, uri.getFragment()));
        wireDefinition.setInterfaceName(interfaceName);
    }

    @Override
    public void generateWireTarget(JavaTargetDefinition definition, LogicalService service) throws GenerationException {
        LogicalComponent component = service.getLeafComponent();
        URI uri = URI.create(component.getUri().toString() + "#" + service.getUri().getFragment());
        definition.setUri(uri);
        ComponentDefinition componentDefinition = component.getDefinition();
        JavaImplementation implementation = (JavaImplementation)componentDefinition.getImplementation();
        InjectingComponentType componentType = (InjectingComponentType)implementation.getComponentType();
        String scope = componentType.getScope();
        definition.setOptimizable(Scope.getScope((String)scope).isSingleton());
    }
}

