/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.java.introspection.JavaImplementationProcessor;
import org.fabric3.implementation.java.model.JavaImplementation;
import org.fabric3.model.type.PolicyAware;
import org.fabric3.model.type.component.ComponentType;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.xml.AbstractValidatingTypeLoader;
import org.fabric3.spi.introspection.xml.LoaderHelper;
import org.fabric3.spi.introspection.xml.LoaderUtil;
import org.fabric3.spi.introspection.xml.MissingAttribute;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaImplementationLoader
extends AbstractValidatingTypeLoader<JavaImplementation> {
    private JavaImplementationProcessor implementationProcessor;
    private LoaderHelper loaderHelper;

    public JavaImplementationLoader(@Reference JavaImplementationProcessor implementationProcessor, @Reference LoaderHelper loaderHelper) {
        this.implementationProcessor = implementationProcessor;
        this.loaderHelper = loaderHelper;
        this.addAttributes(new String[]{"class", "requires", "policySets"});
    }

    public JavaImplementation load(XMLStreamReader reader, IntrospectionContext introspectionContext) throws XMLStreamException {
        this.validateAttributes(reader, introspectionContext);
        JavaImplementation implementation = new JavaImplementation();
        String implClass = reader.getAttributeValue(null, "class");
        if (implClass == null) {
            MissingAttribute failure = new MissingAttribute("The class attribute was not specified", reader);
            introspectionContext.addError((ValidationFailure)failure);
            LoaderUtil.skipToEndElement((XMLStreamReader)reader);
            return implementation;
        }
        this.loaderHelper.loadPolicySetsAndIntents((PolicyAware)implementation, reader, introspectionContext);
        LoaderUtil.skipToEndElement((XMLStreamReader)reader);
        implementation.setImplementationClass(implClass);
        InjectingComponentType componentType = this.implementationProcessor.introspect(implClass, introspectionContext);
        implementation.setComponentType((ComponentType)componentType);
        return implementation;
    }
}

