/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.introspection;

import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.implementation.java.introspection.EagerInitNotSupported;
import org.fabric3.implementation.java.introspection.ImplementationArtifactNotFound;
import org.fabric3.implementation.java.introspection.JavaImplementationProcessor;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.introspection.ImplementationNotFoundException;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.introspection.TypeMapping;
import org.fabric3.spi.introspection.java.HeuristicProcessor;
import org.fabric3.spi.introspection.java.IntrospectionHelper;
import org.fabric3.spi.introspection.java.InvalidImplementation;
import org.fabric3.spi.introspection.java.annotation.ClassVisitor;
import org.fabric3.spi.model.type.java.InjectingComponentType;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaImplementationProcessorImpl
implements JavaImplementationProcessor {
    private final ClassVisitor classVisitor;
    private final HeuristicProcessor heuristic;
    private final IntrospectionHelper helper;

    public JavaImplementationProcessorImpl(@Reference(name="classVisitor") ClassVisitor classVisitor, @Reference(name="heuristic") HeuristicProcessor heuristic, @Reference(name="helper") IntrospectionHelper helper) {
        this.classVisitor = classVisitor;
        this.heuristic = heuristic;
        this.helper = helper;
    }

    public InjectingComponentType introspect(String className, IntrospectionContext context) {
        Class implClass;
        InjectingComponentType componentType = new InjectingComponentType(className);
        componentType.setScope("STATELESS");
        ClassLoader cl = context.getClassLoader();
        try {
            implClass = this.helper.loadClass(className, cl);
        }
        catch (ImplementationNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ClassNotFoundException || cause instanceof NoClassDefFoundError) {
                context.addError((ValidationFailure)new ImplementationArtifactNotFound(className, e.getCause().getMessage()));
            } else {
                context.addError((ValidationFailure)new ImplementationArtifactNotFound(className));
            }
            return componentType;
        }
        if (implClass.isInterface()) {
            InvalidImplementation failure = new InvalidImplementation("Implementation class is an interface", className);
            context.addError((ValidationFailure)failure);
            return componentType;
        }
        TypeMapping mapping = context.getTypeMapping(implClass);
        if (mapping == null) {
            mapping = new TypeMapping();
            context.addTypeMapping(implClass, mapping);
            this.helper.resolveTypeParameters(implClass, mapping);
        }
        try {
            this.classVisitor.visit(componentType, implClass, context);
            this.heuristic.applyHeuristics(componentType, implClass, context);
        }
        catch (NoClassDefFoundError e) {
            context.addError((ValidationFailure)new ImplementationArtifactNotFound(className, e.getMessage()));
        }
        this.validateScope(componentType, implClass, context);
        return componentType;
    }

    private void validateScope(InjectingComponentType componentType, Class<?> implClass, IntrospectionContext context) {
        String scope = componentType.getScope();
        if (componentType.isEagerInit() && !Scope.COMPOSITE.getScope().equals(scope) && !Scope.DOMAIN.getScope().equals(scope)) {
            EagerInitNotSupported warning = new EagerInitNotSupported(implClass);
            context.addWarning((ValidationFailure)warning);
        }
    }
}

