/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import org.fabric3.implementation.java.provision.JavaConnectionSourceDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.ChannelProxyService;
import org.fabric3.implementation.pojo.builder.ProxyCreationException;
import org.fabric3.spi.builder.component.ConnectionAttachException;
import org.fabric3.spi.builder.component.SourceConnectionAttacher;
import org.fabric3.spi.channel.ChannelConnection;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.model.physical.PhysicalConnectionTargetDefinition;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.util.UriHelper;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaSourceConnectionAttacher
implements SourceConnectionAttacher<JavaConnectionSourceDefinition> {
    private ComponentManager manager;
    private ChannelProxyService proxyService;
    private ClassLoaderRegistry classLoaderRegistry;

    public JavaSourceConnectionAttacher(@Reference ComponentManager manager, @Reference ChannelProxyService proxyService, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.proxyService = proxyService;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(JavaConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target, ChannelConnection connection) throws ConnectionAttachException {
        Class type;
        URI sourceUri = source.getUri();
        URI sourceName = UriHelper.getDefragmentedName((URI)sourceUri);
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        if (component == null) {
            throw new ConnectionAttachException("Source component not found: " + sourceName);
        }
        Injectable injectable = source.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(source.getClassLoaderId(), source.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = source.getInterfaceName();
            throw new ConnectionAttachException("Unable to load interface class: " + name, (Throwable)e);
        }
        try {
            ObjectFactory factory = this.proxyService.createObjectFactory(type, connection);
            component.setObjectFactory(injectable, factory);
        }
        catch (ProxyCreationException e) {
            throw new ConnectionAttachException((Throwable)e);
        }
    }

    public void detach(JavaConnectionSourceDefinition source, PhysicalConnectionTargetDefinition target) throws ConnectionAttachException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }
}

