/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.net.URI;
import org.fabric3.implementation.java.provision.JavaSourceDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.KeyInstantiationException;
import org.fabric3.implementation.pojo.builder.PojoSourceWireAttacher;
import org.fabric3.implementation.pojo.builder.ProxyCreationException;
import org.fabric3.implementation.pojo.builder.WireProxyService;
import org.fabric3.model.type.component.Scope;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.SourceWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.ScopeContainer;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.model.type.java.Injectable;
import org.fabric3.spi.model.type.java.InjectableType;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.transform.TransformerRegistry;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.EagerInit;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@EagerInit
public class JavaSourceWireAttacher
extends PojoSourceWireAttacher
implements SourceWireAttacher<JavaSourceDefinition> {
    private ComponentManager manager;
    private WireProxyService proxyService;

    public JavaSourceWireAttacher(@Reference ComponentManager manager, @Reference WireProxyService proxyService, @Reference ClassLoaderRegistry classLoaderRegistry, @Reference TransformerRegistry transformerRegistry) {
        super(transformerRegistry, classLoaderRegistry);
        this.manager = manager;
        this.proxyService = proxyService;
    }

    public void attach(JavaSourceDefinition sourceDefinition, PhysicalTargetDefinition targetDefinition, Wire wire) throws WiringException {
        Class type;
        URI sourceUri = sourceDefinition.getUri();
        URI sourceName = UriHelper.getDefragmentedName((URI)sourceDefinition.getUri());
        JavaComponent source = (JavaComponent)this.manager.getComponent(sourceName);
        if (source == null) {
            throw new WiringException("Source callback not found: " + sourceName);
        }
        Injectable injectable = sourceDefinition.getInjectable();
        try {
            type = this.classLoaderRegistry.loadClass(sourceDefinition.getClassLoaderId(), sourceDefinition.getInterfaceName());
        }
        catch (ClassNotFoundException e) {
            String name = sourceDefinition.getInterfaceName();
            throw new WireAttachException("Unable to load interface class: " + name, sourceUri, null, (Throwable)e);
        }
        if (InjectableType.CALLBACK.equals((Object)injectable.getType())) {
            this.processCallback(wire, targetDefinition, source, injectable, type);
        } else {
            this.processReference(wire, sourceDefinition, targetDefinition, source, injectable, type);
        }
    }

    public void detach(JavaSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        this.detachObjectFactory(source, target);
    }

    public void detachObjectFactory(JavaSourceDefinition source, PhysicalTargetDefinition target) throws WiringException {
        URI sourceName = UriHelper.getDefragmentedName((URI)source.getUri());
        JavaComponent component = (JavaComponent)this.manager.getComponent(sourceName);
        Injectable injectable = source.getInjectable();
        component.removeObjectFactory(injectable);
    }

    public void attachObjectFactory(JavaSourceDefinition sourceDefinition, ObjectFactory<?> factory, PhysicalTargetDefinition targetDefinition) throws WiringException {
        URI sourceId = UriHelper.getDefragmentedName((URI)sourceDefinition.getUri());
        JavaComponent sourceComponent = (JavaComponent)this.manager.getComponent(sourceId);
        Injectable injectable = sourceDefinition.getInjectable();
        if (sourceDefinition.isKeyed()) {
            Object key = this.getKey(sourceDefinition, targetDefinition);
            sourceComponent.setObjectFactory(injectable, factory, key);
        } else {
            sourceComponent.setObjectFactory(injectable, factory);
        }
    }

    private void processReference(Wire wire, JavaSourceDefinition sourceDefinition, PhysicalTargetDefinition targetDefinition, JavaComponent source, Injectable injectable, Class<?> type) throws KeyInstantiationException {
        String callbackUri = null;
        URI uri = targetDefinition.getCallbackUri();
        if (uri != null) {
            callbackUri = uri.toString();
        }
        try {
            ObjectFactory factory = this.proxyService.createObjectFactory(type, wire, callbackUri);
            if (sourceDefinition.isKeyed()) {
                Object key = this.getKey(sourceDefinition, targetDefinition);
                source.setObjectFactory(injectable, factory, key);
            } else {
                source.setObjectFactory(injectable, factory);
            }
        }
        catch (ProxyCreationException e) {
            throw new KeyInstantiationException((Throwable)e);
        }
    }

    private void processCallback(Wire wire, PhysicalTargetDefinition targetDefinition, JavaComponent source, Injectable injectable, Class<?> type) throws KeyInstantiationException {
        URI callbackUri = targetDefinition.getUri();
        ScopeContainer container = source.getScopeContainer();
        ObjectFactory factory = source.getObjectFactory(injectable);
        boolean multiThreaded = Scope.COMPOSITE.equals((Object)container.getScope());
        try {
            factory = factory == null ? this.proxyService.createCallbackObjectFactory(type, multiThreaded, callbackUri, wire) : this.proxyService.updateCallbackObjectFactory(factory, type, multiThreaded, callbackUri, wire);
            source.setObjectFactory(injectable, factory);
        }
        catch (ProxyCreationException e) {
            throw new KeyInstantiationException((Throwable)e);
        }
    }
}

