/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.implementation.java.runtime;

import java.lang.reflect.Method;
import java.net.URI;
import org.fabric3.implementation.java.provision.JavaTargetDefinition;
import org.fabric3.implementation.java.runtime.JavaComponent;
import org.fabric3.implementation.pojo.builder.MethodUtils;
import org.fabric3.implementation.pojo.component.InvokerInterceptor;
import org.fabric3.implementation.pojo.provision.PojoSourceDefinition;
import org.fabric3.spi.builder.WiringException;
import org.fabric3.spi.builder.component.TargetWireAttacher;
import org.fabric3.spi.builder.component.WireAttachException;
import org.fabric3.spi.classloader.ClassLoaderRegistry;
import org.fabric3.spi.cm.ComponentManager;
import org.fabric3.spi.component.AtomicComponent;
import org.fabric3.spi.component.Component;
import org.fabric3.spi.model.physical.PhysicalOperationDefinition;
import org.fabric3.spi.model.physical.PhysicalSourceDefinition;
import org.fabric3.spi.model.physical.PhysicalTargetDefinition;
import org.fabric3.spi.objectfactory.ObjectFactory;
import org.fabric3.spi.util.UriHelper;
import org.fabric3.spi.wire.Interceptor;
import org.fabric3.spi.wire.InvocationChain;
import org.fabric3.spi.wire.Wire;
import org.oasisopen.sca.annotation.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaTargetWireAttacher
implements TargetWireAttacher<JavaTargetDefinition> {
    private final ComponentManager manager;
    private final ClassLoaderRegistry classLoaderRegistry;

    public JavaTargetWireAttacher(@Reference ComponentManager manager, @Reference ClassLoaderRegistry classLoaderRegistry) {
        this.manager = manager;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public void attach(PhysicalSourceDefinition sourceDefinition, JavaTargetDefinition targetDefinition, Wire wire) throws WireAttachException {
        URI targetName = UriHelper.getDefragmentedName((URI)targetDefinition.getUri());
        Component component = this.manager.getComponent(targetName);
        if (component == null) {
            throw new WireAttachException("Target not found: " + targetName);
        }
        JavaComponent target = (JavaComponent)component;
        Class implementationClass = target.getImplementationClass();
        ClassLoader loader = this.classLoaderRegistry.getClassLoader(targetDefinition.getClassLoaderId());
        for (InvocationChain chain : wire.getInvocationChains()) {
            PhysicalOperationDefinition operation = chain.getPhysicalOperation();
            Method method = MethodUtils.findMethod((PhysicalSourceDefinition)sourceDefinition, (PhysicalTargetDefinition)targetDefinition, (PhysicalOperationDefinition)operation, (Class)implementationClass, (ClassLoader)loader, (ClassLoaderRegistry)this.classLoaderRegistry);
            InvokerInterceptor interceptor = sourceDefinition instanceof PojoSourceDefinition && targetDefinition.getClassLoaderId().equals(sourceDefinition.getClassLoaderId()) ? new InvokerInterceptor(method, (AtomicComponent)target) : new InvokerInterceptor(method, (AtomicComponent)target, loader);
            chain.addInterceptor((Interceptor)interceptor);
        }
    }

    public void detach(PhysicalSourceDefinition source, JavaTargetDefinition target) throws WiringException {
    }

    public ObjectFactory<?> createObjectFactory(JavaTargetDefinition target) throws WiringException {
        URI targetId = UriHelper.getDefragmentedName((URI)target.getUri());
        JavaComponent targetComponent = (JavaComponent)this.manager.getComponent(targetId);
        return targetComponent.createObjectFactory();
    }
}

