/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.contribution.impl;

import java.io.IOException;
import java.net.URL;
import org.apache.ws.commons.schema.resolver.URIResolver;
import org.xml.sax.InputSource;

public class ContextClassLoaderResolver
implements URIResolver {
    private URIResolver next;

    public ContextClassLoaderResolver(URIResolver next) {
        this.next = next;
    }

    public InputSource resolveEntity(String targetNamespace, String schemaLocation, String baseUri) {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(schemaLocation);
        if (url != null) {
            return this.createSource(url);
        }
        url = loader.getResource("wsdl/" + schemaLocation);
        if (url != null) {
            return this.createSource(url);
        }
        url = loader.getResource("META-INF/" + schemaLocation);
        if (url != null) {
            return this.createSource(url);
        }
        url = loader.getResource("META-INF/wsdl/" + schemaLocation);
        if (url != null) {
            return this.createSource(url);
        }
        return this.next.resolveEntity(targetNamespace, schemaLocation, baseUri);
    }

    private InputSource createSource(URL url) {
        try {
            return new InputSource(url.openStream());
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }
}

