/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.wsdl.processor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.wsdl.Fault;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.fabric3.host.contribution.ValidationFailure;
import org.fabric3.model.type.contract.DataType;
import org.fabric3.model.type.contract.Operation;
import org.fabric3.spi.introspection.IntrospectionContext;
import org.fabric3.spi.model.type.xsd.XSDComplexType;
import org.fabric3.spi.model.type.xsd.XSDSimpleType;
import org.fabric3.spi.model.type.xsd.XSDType;
import org.fabric3.wsdl.model.WsdlServiceContract;
import org.fabric3.wsdl.processor.SchemaTypeNotFound;
import org.fabric3.wsdl.processor.WsdlContractProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Wsdl11ContractProcessor
implements WsdlContractProcessor {
    @Override
    public WsdlServiceContract introspect(PortType portType, QName wsdlQName, XmlSchemaCollection collection, IntrospectionContext context) {
        LinkedList<Operation> operations = new LinkedList<Operation>();
        for (Object object : portType.getOperations()) {
            javax.wsdl.Operation wsdlOperation = (javax.wsdl.Operation)object;
            Operation operation = this.createOperation(wsdlOperation, collection, portType, context);
            operations.add(operation);
        }
        WsdlServiceContract contract = new WsdlServiceContract(portType, wsdlQName);
        contract.setOperations(operations);
        return contract;
    }

    private Operation createOperation(javax.wsdl.Operation operation, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        Input input = operation.getInput();
        Message message = input.getMessage();
        List<DataType<?>> inputTypes = this.getInputTypes(message, collection, portType, context);
        Map faults = operation.getFaults();
        List<DataType<?>> faultTypes = this.getFaultTypes(faults, collection, portType, context);
        Output output = operation.getOutput();
        DataType<?> outputType = this.getOutputType(output, collection, portType, context);
        String name = operation.getName();
        Operation op = new Operation(name, inputTypes, outputType, faultTypes);
        op.setRemotable(true);
        return op;
    }

    private List<DataType<?>> getInputTypes(Message message, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        ArrayList types = new ArrayList();
        List parts = message.getOrderedParts(null);
        if (parts.isEmpty()) {
            XSDType type = this.getElementDataType(message.getQName(), collection, portType, context);
            types.add((DataType<?>)type);
        } else {
            for (Part part : parts) {
                XSDType dataType = this.getDataType(part, collection, portType, context);
                if (dataType == null) continue;
                types.add((DataType<?>)dataType);
            }
        }
        return types;
    }

    private List<DataType<?>> getFaultTypes(Map faults, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        LinkedList types = new LinkedList();
        for (Fault fault : faults.values()) {
            Part part = (Part)fault.getMessage().getOrderedParts(null).get(0);
            XSDType dataType = this.getDataType(part, collection, portType, context);
            if (dataType == null) continue;
            types.add((DataType<?>)dataType);
        }
        return types;
    }

    private DataType<?> getOutputType(Output output, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        if (output == null) {
            return null;
        }
        Message message = output.getMessage();
        List parts = message.getOrderedParts(null);
        if (parts.isEmpty()) {
            return this.getElementDataType(message.getQName(), collection, portType, context);
        }
        Part part = (Part)parts.get(0);
        return this.getDataType(part, collection, portType, context);
    }

    private XSDType getDataType(Part part, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        QName elementName = part.getElementName();
        XSDType dataType = null;
        QName typeName = part.getTypeName();
        if (elementName != null) {
            dataType = this.getElementDataType(elementName, collection, portType, context);
        } else if (typeName != null) {
            dataType = this.getSchemaDataType(typeName, collection, portType, context);
        }
        return dataType;
    }

    private XSDType getElementDataType(QName elementName, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        XmlSchemaElement element = collection.getElementByQName(elementName);
        if (element == null) {
            SchemaTypeNotFound error = new SchemaTypeNotFound("Schema type " + elementName + " not found referenced in: " + portType.getQName());
            context.addError((ValidationFailure)error);
            return null;
        }
        XmlSchemaType type = element.getSchemaType();
        if (type == null) {
            SchemaTypeNotFound error = new SchemaTypeNotFound("Invalid schema type " + elementName + " referenced in: " + portType.getQName());
            context.addError((ValidationFailure)error);
            return null;
        }
        return this.createDataType(type, elementName);
    }

    private XSDType getSchemaDataType(QName typeName, XmlSchemaCollection collection, PortType portType, IntrospectionContext context) {
        XmlSchemaType type = collection.getTypeByQName(typeName);
        if (type == null) {
            SchemaTypeNotFound error = new SchemaTypeNotFound("Schema type " + typeName + " not found referenced in: " + portType.getQName());
            context.addError((ValidationFailure)error);
            return null;
        }
        return this.createDataType(type, null);
    }

    private XSDType createDataType(XmlSchemaType type, QName elementName) {
        QName name = type.getQName();
        if (name == null) {
            name = elementName;
        }
        if (type instanceof XmlSchemaComplexType) {
            return this.introspectComplexType((XmlSchemaComplexType)type, name);
        }
        if (type instanceof XmlSchemaSimpleType) {
            return new XSDSimpleType(Object.class, name);
        }
        throw new AssertionError((Object)("Unknown Schema type" + type));
    }

    private XSDType introspectComplexType(XmlSchemaComplexType type, QName name) {
        if (type.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence sequence = (XmlSchemaSequence)type.getParticle();
            ArrayList<Object> sequenceTypes = new ArrayList<Object>();
            Iterator iter = sequence.getItems().getIterator();
            while (iter.hasNext()) {
                QName schemaTypeName;
                XmlSchemaObject o = (XmlSchemaObject)iter.next();
                if (o instanceof XmlSchemaElement) {
                    XmlSchemaElement schemaElement = (XmlSchemaElement)o;
                    schemaTypeName = schemaElement.getSchemaTypeName();
                    XmlSchemaType schemaType = schemaElement.getSchemaType();
                    if (schemaType instanceof XmlSchemaComplexType) {
                        sequenceTypes.add(new XSDComplexType(Object.class, schemaTypeName));
                        continue;
                    }
                    if (!(schemaType instanceof XmlSchemaSimpleType)) continue;
                    sequenceTypes.add(new XSDSimpleType(Object.class, schemaTypeName));
                    continue;
                }
                if (!(o instanceof XmlSchemaType)) continue;
                XmlSchemaType schemaType = (XmlSchemaType)o;
                schemaTypeName = schemaType.getQName();
                if (schemaType instanceof XmlSchemaComplexType) {
                    sequenceTypes.add(new XSDComplexType(Object.class, schemaTypeName));
                    continue;
                }
                if (!(schemaType instanceof XmlSchemaSimpleType)) continue;
                sequenceTypes.add(new XSDSimpleType(Object.class, schemaTypeName));
            }
            return new XSDComplexType(Object.class, name, sequenceTypes);
        }
        return new XSDComplexType(Object.class, name);
    }
}

