/*
 * Decompiled with CFR 0.152.
 */
package org.fabric3.contribution.scanner.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.xml.stream.Location;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.fabric3.api.annotation.monitor.Monitor;
import org.fabric3.contribution.scanner.impl.ContributionTracker;
import org.fabric3.contribution.scanner.impl.ContributionTrackerMonitor;
import org.fabric3.host.runtime.HostInfo;
import org.fabric3.spi.xml.XMLFactory;
import org.oasisopen.sca.annotation.Init;
import org.oasisopen.sca.annotation.Reference;

public class ContributionTrackerImpl
implements ContributionTracker {
    private static final String CONTRIBUTION = "contribution";
    private XMLFactory xmlFactory;
    private HostInfo info;
    private ContributionTrackerMonitor monitor;
    private File journal;
    private XMLInputFactory inputFactory;
    private XMLOutputFactory outputFactory;
    private Set<String> tracked = new HashSet<String>();

    public ContributionTrackerImpl(@Reference XMLFactory xmlFactory, @Reference HostInfo info, @Monitor ContributionTrackerMonitor monitor) {
        this.xmlFactory = xmlFactory;
        this.info = info;
        this.monitor = monitor;
    }

    @Init
    public void init() throws XMLStreamException, FileNotFoundException {
        this.journal = new File(this.info.getDataDir(), "contributions.xml");
        this.inputFactory = this.xmlFactory.newInputFactoryInstance();
        this.outputFactory = this.xmlFactory.newOutputFactoryInstance();
        this.read();
    }

    public synchronized void addResource(String name) {
        this.tracked.add(name);
        this.persist();
    }

    public synchronized void removeResource(String name) {
        this.tracked.remove(name);
        this.persist();
    }

    public synchronized boolean isTracked(String name) {
        return this.tracked.contains(name);
    }

    private void read() throws XMLStreamException, FileNotFoundException {
        if (!this.journal.exists()) {
            return;
        }
        FileInputStream fis = new FileInputStream(this.journal);
        BufferedInputStream stream = new BufferedInputStream(fis);
        XMLStreamReader reader = this.inputFactory.createXMLStreamReader(stream);
        try {
            block12: while (true) {
                switch (reader.next()) {
                    case 1: {
                        if (!CONTRIBUTION.equals(reader.getLocalName())) break;
                        String name = reader.getAttributeValue(null, "name");
                        if (name == null) {
                            Location location = reader.getLocation();
                            int line = location.getLineNumber();
                            int col = location.getColumnNumber();
                            this.monitor.errorMessage("Name attribute missing in contribution journal [" + line + "," + col + "]");
                            continue block12;
                        }
                        this.tracked.add(name);
                        break;
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persist() {
        FilterOutputStream stream = null;
        try {
            FileOutputStream fos = new FileOutputStream(this.journal);
            stream = new BufferedOutputStream(fos);
            XMLStreamWriter writer = this.outputFactory.createXMLStreamWriter(stream);
            writer.writeStartDocument();
            writer.writeStartElement("contributions");
            writer.writeDefaultNamespace("urn:fabric3.org");
            for (String entry : this.tracked) {
                writer.writeStartElement(CONTRIBUTION);
                writer.writeAttribute("name", entry);
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.writeEndDocument();
        }
        catch (XMLStreamException e) {
            if (this.journal.exists()) {
                this.journal.delete();
            }
            this.monitor.error(e);
        }
        catch (IOException e) {
            if (this.journal.exists()) {
                this.journal.delete();
            }
            this.monitor.error(e);
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException e) {}
        }
    }
}

